/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build;

import java.io.IOException;
import org.basex.build.Builder;
import org.basex.build.Parser;
import org.basex.core.Context;
import org.basex.core.cmd.DropDB;
import org.basex.data.DiskData;
import org.basex.data.MetaData;
import org.basex.index.name.Names;
import org.basex.io.IO;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.io.out.TableOutput;
import org.basex.io.random.TableAccess;
import org.basex.io.random.TableDiskAccess;
import org.basex.util.Compress;
import org.basex.util.Performance;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.Util;

public final class DiskBuilder
extends Builder {
    private static final ThreadLocal<Compress> COMP = new ThreadLocal<Compress>(){

        @Override
        protected Compress initialValue() {
            return new Compress();
        }
    };
    private DataOutput tout;
    private DataOutput xout;
    private DataOutput vout;
    private DataOutput sout;
    private final Context context;
    private int c;

    public DiskBuilder(String nm, Parser parse, Context ctx) {
        super(nm, parse);
        this.context = ctx;
    }

    @Override
    public DiskData build() throws IOException {
        IO file = this.parser.src;
        MetaData md = new MetaData(this.dbname, this.context);
        md.original = file != null ? file.path() : "";
        md.filesize = file != null ? file.length() : 0L;
        md.time = file != null ? file.timeStamp() : System.currentTimeMillis();
        md.dirty = true;
        Runtime rt = Runtime.getRuntime();
        int bs = (int)Math.min(md.filesize, Math.min(0x400000L, rt.maxMemory() - rt.freeMemory() >> 2));
        bs = Math.max(4096, bs - bs % 4096);
        DropDB.drop(this.dbname, this.context);
        this.context.globalopts.dbpath(this.dbname).md();
        this.meta = md;
        this.tags = new Names(md);
        this.atts = new Names(md);
        try {
            this.tout = new DataOutput(new TableOutput(md, "tbl"));
            this.xout = new DataOutput(md.dbfile("txt"), bs);
            this.vout = new DataOutput(md.dbfile("atv"), bs);
            this.sout = new DataOutput(md.dbfile("tmp"), bs);
            Performance perf = Prop.debug ? new Performance() : null;
            Util.debug(this.tit() + "...", new Object[0]);
            this.parse();
            if (Prop.debug) {
                Util.errln(" " + perf + " (" + Performance.getMemory() + ')', new Object[0]);
            }
        }
        catch (IOException ex) {
            try {
                this.close();
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw ex;
        }
        this.close();
        DataInput in = new DataInput(md.dbfile("tmp"));
        TableDiskAccess ta = new TableDiskAccess(md, true);
        while (this.spos < this.ssize) {
            ((TableAccess)ta).write4(in.readNum(), 8, in.readNum());
            ++this.spos;
        }
        ((TableAccess)ta).close();
        in.close();
        md.dbfile("tmp").delete();
        DiskData data = new DiskData(md, this.tags, this.atts, this.path, this.ns);
        data.finishUpdate();
        return data;
    }

    @Override
    public void abort() {
        try {
            this.close();
        }
        catch (IOException ex) {
            Util.debug(ex);
        }
        if (this.meta != null) {
            DropDB.drop(this.meta.name, this.context);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.tout != null) {
            this.tout.close();
        }
        if (this.xout != null) {
            this.xout.close();
        }
        if (this.vout != null) {
            this.vout.close();
        }
        if (this.sout != null) {
            this.sout.close();
        }
        this.parser.close();
        this.tout = null;
        this.xout = null;
        this.vout = null;
        this.sout = null;
    }

    @Override
    protected void addDoc(byte[] value) throws IOException {
        this.tout.write1(0);
        this.tout.write2(0);
        this.tout.write5(this.textOff(value, true));
        this.tout.write4(0);
        this.tout.write4(this.meta.size++);
    }

    @Override
    protected void addElem(int dist, int nm, int asize, int uri, boolean ne) throws IOException {
        this.tout.write1(asize << 3 | 1);
        this.tout.write2((ne ? 32768 : 0) | nm);
        this.tout.write1(uri);
        this.tout.write4(dist);
        this.tout.write4(asize);
        this.tout.write4(this.meta.size++);
        if (Prop.debug && (this.c++ & 0x7FFFF) == 0) {
            Util.err(".", new Object[0]);
        }
    }

    @Override
    protected void addAttr(int nm, byte[] value, int dist, int uri) throws IOException {
        this.tout.write1(dist << 3 | 3);
        this.tout.write2(nm);
        this.tout.write5(this.textOff(value, false));
        this.tout.write4(uri);
        this.tout.write4(this.meta.size++);
    }

    @Override
    protected void addText(byte[] value, int dist, byte kind) throws IOException {
        this.tout.write1(kind);
        this.tout.write2(0);
        this.tout.write5(this.textOff(value, true));
        this.tout.write4(dist);
        this.tout.write4(this.meta.size++);
    }

    @Override
    protected void setSize(int pre, int size) throws IOException {
        this.sout.writeNum(pre);
        this.sout.writeNum(size);
        ++this.ssize;
    }

    private long textOff(byte[] value, boolean text) throws IOException {
        long v = Token.toSimpleInt(value);
        if (v != Integer.MIN_VALUE) {
            return v | 0x8000000000L;
        }
        DataOutput store = text ? this.xout : this.vout;
        long off = store.size();
        byte[] val = COMP.get().pack(value);
        store.writeToken(val);
        return val == value ? off : off | 0x4000000000L;
    }
}

