/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build;

import java.io.IOException;
import org.basex.build.Builder;
import org.basex.build.Parser;
import org.basex.core.Context;
import org.basex.data.Data;
import org.basex.data.MemData;
import org.basex.data.MetaData;
import org.basex.io.IO;

public final class MemBuilder
extends Builder {
    private MemData data;

    public MemBuilder(String nm, Parser parse) {
        super(nm, parse);
    }

    public static MemData build(IO input, Context context) throws IOException {
        return MemBuilder.build(Parser.xmlParser(input, context.options));
    }

    public static MemData build(Parser parser) throws IOException {
        return MemBuilder.build(parser.src.dbname(), parser);
    }

    public static MemData build(String name, Parser parser) throws IOException {
        return new MemBuilder(name, parser).build();
    }

    @Override
    public MemData build() throws IOException {
        this.init();
        try {
            this.parse();
        }
        catch (IOException ex) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ex;
        }
        this.close();
        return this.data;
    }

    public void init() {
        this.data = new MemData(this.path, this.ns, this.parser.options);
        MetaData md = this.data.meta;
        md.name = this.dbname;
        md.createtext = true;
        md.createattr = true;
        md.textindex = true;
        md.attrindex = true;
        IO file = this.parser.src;
        md.original = file != null ? file.path() : "";
        md.filesize = file != null ? file.length() : 0L;
        md.time = file != null ? file.timeStamp() : System.currentTimeMillis();
        this.meta = this.data.meta;
        this.tags = this.data.tagindex;
        this.atts = this.data.atnindex;
        this.path.data(this.data);
    }

    public Data data() {
        return this.data;
    }

    @Override
    public void close() throws IOException {
        this.parser.close();
    }

    @Override
    protected void addDoc(byte[] value) {
        this.data.doc(this.meta.size, 0, value);
        this.data.insert(this.meta.size);
    }

    @Override
    protected void addElem(int dist, int nm, int asize, int uri, boolean ne) {
        this.data.elem(dist, nm, asize, asize, uri, ne);
        this.data.insert(this.meta.size);
    }

    @Override
    protected void addAttr(int nm, byte[] value, int dist, int uri) {
        this.data.attr(this.meta.size, dist, nm, value, uri, false);
        this.data.insert(this.meta.size);
    }

    @Override
    protected void addText(byte[] value, int dist, byte kind) {
        this.data.text(this.meta.size, dist, value, kind);
        this.data.insert(this.meta.size);
    }

    @Override
    protected void setSize(int pre, int size) {
        this.data.size(pre, 1, size);
    }
}

