/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build;

import java.io.IOException;
import org.basex.build.Builder;
import org.basex.build.CsvParser;
import org.basex.build.HtmlParser;
import org.basex.build.JsonParser;
import org.basex.build.SingleParser;
import org.basex.build.TextParser;
import org.basex.build.xml.SAXWrapper;
import org.basex.build.xml.XMLParser;
import org.basex.core.MainOptions;
import org.basex.core.Proc;
import org.basex.io.IO;
import org.basex.util.Atts;

public abstract class Parser
extends Proc {
    public IO src;
    protected final Atts atts = new Atts();
    protected final Atts nsp = new Atts();
    protected final MainOptions options;
    String target = "";

    protected Parser(String source, MainOptions opts) {
        this(source == null ? null : IO.get(source), opts);
    }

    protected Parser(IO source, MainOptions opts) {
        this.src = source;
        this.options = opts;
    }

    public abstract void parse(Builder var1) throws IOException;

    public void close() throws IOException {
    }

    public String info() {
        return "";
    }

    public Parser target(String path) {
        this.target = path.isEmpty() ? "" : (path + '/').replaceAll("//+", "/");
        return this;
    }

    public static Parser emptyParser(MainOptions options) {
        return new Parser((IO)null, options){

            @Override
            public void parse(Builder build) {
            }
        };
    }

    public static SingleParser xmlParser(IO in, MainOptions options) throws IOException {
        return options.get(MainOptions.INTPARSE) != false ? new XMLParser(in, options) : new SAXWrapper(in, options);
    }

    public static SingleParser singleParser(IO in, MainOptions options, String target) throws IOException {
        SingleParser p;
        MainOptions.MainParser mp = options.get(MainOptions.PARSER);
        switch (mp) {
            case HTML: {
                p = new HtmlParser(in, options);
                break;
            }
            case TEXT: {
                p = new TextParser(in, options);
                break;
            }
            case JSON: {
                p = new JsonParser(in, options);
                break;
            }
            case CSV: {
                p = new CsvParser(in, options);
                break;
            }
            default: {
                p = Parser.xmlParser(in, options);
            }
        }
        p.target(target);
        return p;
    }
}

