/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import java.util.Random;
import org.basex.io.IOFile;
import org.basex.util.Prop;
import org.basex.util.options.BooleanOption;
import org.basex.util.options.Comment;
import org.basex.util.options.NumberOption;
import org.basex.util.options.Options;
import org.basex.util.options.StringOption;

public final class GlobalOptions
extends Options {
    private static final boolean USERHOME = Prop.HOME.equals(Prop.USERHOME);
    public static final Comment C_GENERAL = new Comment("General Options");
    public static final BooleanOption DEBUG = new BooleanOption("DEBUG", false);
    public static final StringOption DBPATH = new StringOption("DBPATH", Prop.HOME + (USERHOME ? "BaseXData" : "data"));
    public static final StringOption REPOPATH = new StringOption("REPOPATH", Prop.HOME + (USERHOME ? "BaseXRepo" : "repo"));
    public static final StringOption LANG = new StringOption("LANG", Prop.language);
    public static final BooleanOption LANGKEYS = new BooleanOption("LANGKEYS", false);
    public static final BooleanOption GLOBALLOCK = new BooleanOption("GLOBALLOCK", false);
    public static final Comment C_CLIENT = new Comment("Client/Server Architecture");
    public static final StringOption HOST = new StringOption("HOST", "localhost");
    public static final NumberOption PORT = new NumberOption("PORT", 1984);
    public static final NumberOption SERVERPORT = new NumberOption("SERVERPORT", 1984);
    public static final NumberOption EVENTPORT = new NumberOption("EVENTPORT", 1985);
    public static final StringOption USER = new StringOption("USER", "");
    public static final StringOption PASSWORD = new StringOption("PASSWORD", "");
    public static final StringOption SERVERHOST = new StringOption("SERVERHOST", "");
    public static final StringOption PROXYHOST = new StringOption("PROXYHOST", "");
    public static final NumberOption PROXYPORT = new NumberOption("PROXYPORT", 80);
    public static final StringOption NONPROXYHOSTS = new StringOption("NONPROXYHOSTS", "");
    public static final NumberOption TIMEOUT = new NumberOption("TIMEOUT", 30);
    public static final NumberOption KEEPALIVE = new NumberOption("KEEPALIVE", 600);
    public static final NumberOption PARALLEL = new NumberOption("PARALLEL", 8);
    public static final BooleanOption LOG = new BooleanOption("LOG", true);
    public static final NumberOption LOGMSGMAXLEN = new NumberOption("LOGMSGMAXLEN", 1000);
    public static final Comment C_HTTP = new Comment("HTTP Services");
    public static final StringOption WEBPATH = new StringOption("WEBPATH", Prop.HOME + (USERHOME ? "BaseXWeb" : "webapp"));
    public static final StringOption RESTXQPATH = new StringOption("RESTXQPATH", "");
    public static final BooleanOption HTTPLOCAL = new BooleanOption("HTTPLOCAL", false);
    public static final NumberOption STOPPORT = new NumberOption("STOPPORT", 8985);

    GlobalOptions(boolean file) {
        super(file ? new IOFile(Prop.HOME + ".basex") : null);
        this.setSystem();
        Prop.language = this.get(LANG);
        Prop.langkeys = this.get(LANGKEYS);
        Prop.debug = this.get(DEBUG);
        String ph = this.get(PROXYHOST);
        String pp = Integer.toString(this.get(PROXYPORT));
        GlobalOptions.setSystem("http.proxyHost", (Object)ph);
        GlobalOptions.setSystem("http.proxyPort", (Object)pp);
        GlobalOptions.setSystem("https.proxyHost", (Object)ph);
        GlobalOptions.setSystem("https.proxyPort", (Object)pp);
        GlobalOptions.setSystem("http.nonProxyHosts", (Object)this.get(NONPROXYHOSTS));
    }

    public IOFile dbpath(String db) {
        return new IOFile(this.get(DBPATH), db);
    }

    public String random(String db) {
        String nm;
        while (this.dbpath(nm = db + '_' + new Random().nextInt(Integer.MAX_VALUE)).exists()) {
        }
        return nm;
    }

    public IOFile dbpath() {
        return new IOFile(this.get(DBPATH));
    }

    public boolean dbexists(String db) {
        return !db.isEmpty() && this.dbpath(db).exists();
    }
}

