/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.build.DirParser;
import org.basex.build.DiskBuilder;
import org.basex.build.MemBuilder;
import org.basex.build.Parser;
import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.Databases;
import org.basex.core.LockResult;
import org.basex.core.MainOptions;
import org.basex.core.Perm;
import org.basex.core.ProcException;
import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.Open;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.data.Data;
import org.basex.data.DiskData;
import org.basex.data.MemData;
import org.basex.index.IndexType;
import org.basex.index.ft.FTBuilder;
import org.basex.index.value.ValueIndexBuilder;
import org.basex.io.IO;
import org.basex.io.IOStream;
import org.basex.io.in.LookupInput;
import org.basex.util.Util;

public final class CreateDB
extends ACreate {
    private Parser parser;

    public CreateDB(String name) {
        this(name, (String)null);
    }

    public CreateDB(String name, String input) {
        super(name, input);
    }

    public void setParser(Parser p) {
        this.parser = p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean run() {
        IO io;
        String name = this.args[0];
        if (!Databases.validName(name)) {
            return this.error(Text.NAME_INVALID_X, name);
        }
        try {
            io = this.sourceToIO(name);
            if (this.in != null) {
                LookupInput li = new LookupInput(io.inputStream());
                io = li.lookup() == -1 ? null : new IOStream(li, io.name());
            }
        }
        catch (IOException ex) {
            return this.error(Util.message(ex), new Object[0]);
        }
        try {
            if (io != null) {
                if (!io.exists()) {
                    return this.error(Text.RES_NOT_FOUND_X, io);
                }
                this.parser = new DirParser(io, this.context, this.goptions.dbpath(name));
            } else if (this.parser == null) {
                this.parser = Parser.emptyParser(this.context.options);
            }
            new Close().run(this.context);
            if (this.options.get(MainOptions.MAINMEM).booleanValue()) {
                MemData data = this.proc(new MemBuilder(name, this.parser)).build();
                this.context.openDB(data);
                this.context.dbs.add(data);
            } else {
                if (this.context.pinned(name)) {
                    return this.error(Text.DB_PINNED_X, name);
                }
                this.proc(new DiskBuilder(name, this.parser, this.context)).build().close();
                Open open = new Open(name);
                if (!open.run(this.context)) {
                    return this.error(open.info(), new Object[0]);
                }
                Data data = this.context.data();
                try {
                    if (data.meta.createtext) {
                        CreateDB.create(IndexType.TEXT, data, this);
                    }
                    if (data.meta.createattr) {
                        CreateDB.create(IndexType.ATTRIBUTE, data, this);
                    }
                    if (data.meta.createftxt) {
                        CreateDB.create(IndexType.FULLTEXT, data, this);
                    }
                }
                finally {
                    data.finishUpdate();
                }
            }
            if (this.options.get(MainOptions.CREATEONLY).booleanValue()) {
                new Close().run(this.context);
            }
            return this.info(this.parser.info() + Text.DB_CREATED_X_X, name, this.perf);
        }
        catch (ProcException ex) {
            throw ex;
        }
        catch (IOException ex) {
            this.abort();
            return this.error(Util.message(ex), new Object[0]);
        }
        catch (Exception ex) {
            Util.debug(ex);
            this.abort();
            return this.error(Text.NOT_PARSED_X, this.parser.src);
        }
    }

    @Override
    public void databases(LockResult lr) {
        lr.read.add("%CTX");
        lr.write.add(this.args[0]);
    }

    public static synchronized Data create(String name, Parser parser, Context ctx) throws IOException {
        return CreateDB.create(name, parser, ctx, ctx.options.get(MainOptions.MAINMEM));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Data create(String name, Parser parser, Context ctx, boolean mem) throws IOException {
        if (!ctx.user.has(Perm.CREATE)) {
            throw new BaseXException(Text.PERM_REQUIRED_X, new Object[]{Perm.CREATE});
        }
        if (mem) {
            return MemBuilder.build(name, parser);
        }
        if (ctx.pinned(name)) {
            throw new BaseXException(Text.DB_PINNED_X, name);
        }
        DiskBuilder builder = new DiskBuilder(name, parser, ctx);
        try {
            DiskData data = builder.build();
            if (data.meta.createtext) {
                ((Data)data).setIndex(IndexType.TEXT, new ValueIndexBuilder((Data)data, true).build());
            }
            if (data.meta.createattr) {
                ((Data)data).setIndex(IndexType.ATTRIBUTE, new ValueIndexBuilder((Data)data, false).build());
            }
            if (data.meta.createftxt) {
                ((Data)data).setIndex(IndexType.FULLTEXT, new FTBuilder(data).build());
            }
            ((Data)data).close();
        }
        finally {
            builder.close();
        }
        return Open.open(name, ctx);
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init((Object)((Object)Commands.Cmd.CREATE) + " " + (Object)((Object)Commands.CmdCreate.DB)).args();
    }
}

