/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.core.LockResult;
import org.basex.core.Perm;
import org.basex.core.Text;
import org.basex.core.User;
import org.basex.core.cmd.AUser;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.Open;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.data.Data;
import org.basex.util.Util;

public final class Grant
extends AUser {
    private Perm prm;

    public Grant(Object permission, String user) {
        this(permission, user, null);
    }

    public Grant(Object permission, String user, String db) {
        super(permission.toString(), user, db);
    }

    @Override
    protected boolean run() {
        Commands.CmdPerm cmd = this.getOption(Commands.CmdPerm.class);
        if (cmd == Commands.CmdPerm.NONE) {
            this.prm = Perm.NONE;
        } else if (cmd == Commands.CmdPerm.READ) {
            this.prm = Perm.READ;
        } else if (cmd == Commands.CmdPerm.WRITE) {
            this.prm = Perm.WRITE;
        } else if (cmd == Commands.CmdPerm.CREATE && this.args[2] == null) {
            this.prm = Perm.CREATE;
        } else if (cmd == Commands.CmdPerm.ADMIN && this.args[2] == null) {
            this.prm = Perm.ADMIN;
        }
        if (this.prm == null) {
            return this.error(Text.PERM_UNKNOWN_X, this.args[0]);
        }
        return this.run(1, false);
    }

    @Override
    protected boolean run(String user, String db) {
        Data data;
        if (user.equals("admin")) {
            return !this.info(Text.ADMIN_STATIC_X, new Object[0]);
        }
        if (db == null) {
            this.context.users.get((String)user).perm = this.prm;
            this.context.users.write();
            return this.info(Text.GRANTED_X_X, this.args[0], user);
        }
        try {
            data = Open.open(db, this.context);
        }
        catch (IOException ex) {
            return !this.info(Util.message(ex), new Object[0]);
        }
        if (!data.startUpdate()) {
            return !this.info(Text.DB_PINNED_X, data.meta.name);
        }
        User u = data.meta.users.get(user);
        if (u == null) {
            u = this.context.users.get(user).copy();
            data.meta.users.create(u);
        }
        u.perm = this.prm;
        data.meta.dirty = true;
        data.finishUpdate();
        Close.close(data, this.context);
        return this.info(Text.GRANTED_ON_X_X_X, this.args[0], user, db);
    }

    @Override
    public void databases(LockResult lr) {
        super.databases(lr);
        if (!this.databases(lr.write, 2)) {
            lr.writeAll = true;
        }
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init().arg(0).arg("ON", 2).arg("TO", 1);
    }
}

