/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import java.util.Date;
import org.basex.core.LockResult;
import org.basex.core.MainOptions;
import org.basex.core.Perm;
import org.basex.core.Text;
import org.basex.core.cmd.AInfo;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.data.MetaData;
import org.basex.util.DateTime;
import org.basex.util.Performance;
import org.basex.util.TokenBuilder;

public final class InfoDB
extends AInfo {
    public InfoDB() {
        super(true, new String[0]);
    }

    @Override
    protected boolean run() throws IOException {
        boolean create = this.context.user.has(Perm.CREATE);
        this.out.print(InfoDB.db(this.context.data().meta, false, true, create));
        return true;
    }

    @Override
    public void databases(LockResult lr) {
        lr.read.add("%CTX");
    }

    public static String db(MetaData meta, boolean bold, boolean index, boolean create) {
        TokenBuilder tb = new TokenBuilder();
        String header = (bold ? new TokenBuilder().bold().add(37).norm().toString() : "%") + Text.NL;
        tb.addExt(header, Text.DB_PROPS);
        InfoDB.info(tb, Text.NAME, meta.name);
        InfoDB.info(tb, Text.SIZE, Performance.format(meta.dbsize()));
        InfoDB.info(tb, Text.NODES, meta.size);
        InfoDB.info(tb, Text.DOCUMENTS, meta.ndocs);
        InfoDB.info(tb, Text.BINARIES, meta.path != null ? meta.binaries().descendants().size() : 0);
        InfoDB.info(tb, Text.TIMESTAMP, DateTime.format(new Date(meta.dbtime()), DateTime.DATETIME));
        if (meta.corrupt) {
            tb.add(' ' + Text.DB_CORRUPT + Text.NL);
        }
        tb.add(Text.NL).addExt(header, Text.RES_PROPS);
        if (create && !meta.original.isEmpty()) {
            InfoDB.info(tb, Text.INPUT_PATH, meta.original);
        }
        if (meta.filesize != 0L) {
            InfoDB.info(tb, Text.INPUT_SIZE, Performance.format(meta.filesize));
        }
        InfoDB.info(tb, Text.TIMESTAMP, DateTime.format(new Date(meta.time), DateTime.DATETIME));
        InfoDB.info(tb, Text.ENCODING, meta.encoding);
        InfoDB.info(tb, MainOptions.CHOP.name(), meta.chop);
        if (index) {
            tb.add(Text.NL).addExt(header, Text.INDEXES);
            if (meta.oldindex()) {
                tb.add(' ' + Text.H_INDEX_FORMAT + Text.NL);
            } else {
                InfoDB.info(tb, Text.UP_TO_DATE, meta.uptodate);
                InfoDB.info(tb, MainOptions.TEXTINDEX.name(), meta.textindex);
                InfoDB.info(tb, MainOptions.ATTRINDEX.name(), meta.attrindex);
                InfoDB.info(tb, MainOptions.FTINDEX.name(), meta.ftxtindex);
                InfoDB.info(tb, MainOptions.LANGUAGE.name(), meta.language);
                InfoDB.info(tb, MainOptions.STEMMING.name(), meta.stemming);
                InfoDB.info(tb, MainOptions.CASESENS.name(), meta.casesens);
                InfoDB.info(tb, MainOptions.DIACRITICS.name(), meta.diacritics);
                InfoDB.info(tb, MainOptions.STOPWORDS.name(), meta.stopwords);
                InfoDB.info(tb, MainOptions.UPDINDEX.name(), meta.updindex);
                InfoDB.info(tb, MainOptions.MAXCATS.name(), meta.maxcats);
                InfoDB.info(tb, MainOptions.MAXLEN.name(), meta.maxlen);
            }
        }
        return tb.toString();
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init((Object)((Object)Commands.Cmd.INFO) + " " + (Object)((Object)Commands.CmdInfo.DB));
    }
}

