/*
 * Decompiled with CFR 0.152.
 */
package org.basex.data;

import java.io.IOException;
import org.basex.build.BuildException;
import org.basex.core.Context;
import org.basex.core.GlobalOptions;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.core.Users;
import org.basex.core.cmd.DropDB;
import org.basex.io.IOFile;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.Version;
import org.basex.util.ft.Language;

public final class MetaData {
    public final IOFile path;
    public final MainOptions options;
    public volatile String name;
    public volatile Users users;
    public volatile String encoding = "UTF-8";
    public volatile String original = "";
    public volatile long filesize;
    public volatile int ndocs;
    public volatile long time;
    public volatile boolean chop;
    public volatile boolean updindex;
    public volatile boolean textindex;
    public volatile boolean attrindex;
    public volatile boolean ftxtindex;
    public volatile boolean createtext;
    public volatile boolean createattr;
    public volatile boolean createftxt;
    public volatile boolean stemming;
    public volatile boolean casesens;
    public volatile boolean diacritics;
    public volatile String stopwords = "";
    public volatile int maxcats;
    public volatile int maxlen;
    public volatile Language language;
    public volatile boolean uptodate = true;
    public volatile boolean corrupt;
    public volatile boolean dirty;
    public volatile int size;
    public volatile int lastid = -1;
    private volatile boolean oldindex;
    private volatile boolean wcindex;
    private volatile int scoring;

    public MetaData(MainOptions opts) {
        this("", opts, null);
    }

    public MetaData(String db, Context ctx) {
        this(db, ctx.options, ctx.globalopts);
    }

    private MetaData(String db, MainOptions opts, GlobalOptions gopts) {
        this.path = gopts != null ? gopts.dbpath(db) : null;
        this.options = opts;
        this.name = db;
        this.chop = this.options.get(MainOptions.CHOP);
        this.createtext = this.options.get(MainOptions.TEXTINDEX);
        this.createattr = this.options.get(MainOptions.ATTRINDEX);
        this.createftxt = this.options.get(MainOptions.FTINDEX);
        this.diacritics = this.options.get(MainOptions.DIACRITICS);
        this.stemming = this.options.get(MainOptions.STEMMING);
        this.casesens = this.options.get(MainOptions.CASESENS);
        this.updindex = this.options.get(MainOptions.UPDINDEX);
        this.maxlen = this.options.get(MainOptions.MAXLEN);
        this.maxcats = this.options.get(MainOptions.MAXCATS);
        this.stopwords = this.options.get(MainOptions.STOPWORDS);
        this.language = Language.get(this.options);
        this.users = new Users(null);
    }

    public static String normPath(String path) {
        StringBuilder sb = new StringBuilder();
        boolean slash = false;
        for (int p = 0; p < path.length(); ++p) {
            char c = path.charAt(p);
            if (c == '\\' || c == '/') {
                if (!slash && p != 0) {
                    sb.append('/');
                }
                slash = true;
                continue;
            }
            if (Prop.WIN && ":*?\"<>\\|".indexOf(c) != -1) {
                return null;
            }
            if (slash) {
                slash = false;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static long dbsize(IOFile io) {
        long s = 0L;
        if (io.isDir()) {
            for (IOFile f : io.children()) {
                s += MetaData.dbsize(f);
            }
        } else {
            s += io.length();
        }
        return s;
    }

    public static IOFile file(IOFile path, String fn) {
        return new IOFile(path, fn + ".basex");
    }

    public boolean oldindex() {
        return this.oldindex || this.wcindex || this.scoring != 0;
    }

    public long dbsize() {
        return this.path != null ? MetaData.dbsize(this.path) : 0L;
    }

    public long dbtime() {
        return this.path != null ? this.path.timeStamp() : 0L;
    }

    public IOFile dbfile(String fn) {
        return MetaData.file(this.path, fn);
    }

    public IOFile binaries() {
        return new IOFile(this.path, "raw");
    }

    public IOFile binary(String pth) {
        if (this.path == null) {
            return null;
        }
        IOFile dir = this.binaries();
        IOFile file = new IOFile(dir, pth);
        return file.path().startsWith(dir.path()) ? file : null;
    }

    public synchronized boolean drop(String pat) {
        return this.path != null && DropDB.drop(this.path, pat + ".basex");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read() throws IOException {
        DataInput di = null;
        try {
            di = new DataInput(this.dbfile("inf"));
            this.read(di);
        }
        finally {
            if (di != null) {
                try {
                    di.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void read(DataInput in) throws IOException {
        String k;
        String storage = "";
        String istorage = "";
        while (!(k = Token.string(in.readToken())).isEmpty()) {
            if (k.equals("PERM")) {
                this.users.read(in);
                continue;
            }
            String v = Token.string(in.readToken());
            if (k.equals("STORAGE")) {
                storage = v;
                continue;
            }
            if (k.equals("ISTORAGE")) {
                istorage = v;
                continue;
            }
            if (k.equals("FNAME")) {
                this.original = v;
                continue;
            }
            if (k.equals("ENCODING")) {
                this.encoding = v;
                continue;
            }
            if (k.equals("FTSTOP")) {
                this.stopwords = v;
                continue;
            }
            if (k.equals("FTLANG")) {
                this.language = Language.get(v);
                continue;
            }
            if (k.equals("SIZE")) {
                this.size = Token.toInt(v);
                continue;
            }
            if (k.equals("NDOCS")) {
                this.ndocs = Token.toInt(v);
                continue;
            }
            if (k.equals("FTSCTYPE")) {
                this.scoring = Token.toInt(v);
                continue;
            }
            if (k.equals("MAXLEN")) {
                this.maxlen = Token.toInt(v);
                continue;
            }
            if (k.equals("MAXCATS")) {
                this.maxcats = Token.toInt(v);
                continue;
            }
            if (k.equals("LASTID")) {
                this.lastid = Token.toInt(v);
                continue;
            }
            if (k.equals("TIME")) {
                this.time = Token.toLong(v);
                continue;
            }
            if (k.equals("FSIZE")) {
                this.filesize = Token.toLong(v);
                continue;
            }
            if (k.equals("FTDC")) {
                this.diacritics = MetaData.toBool(v);
                continue;
            }
            if (k.equals("CHOPPED")) {
                this.chop = MetaData.toBool(v);
                continue;
            }
            if (k.equals("UPDINDEX")) {
                this.updindex = MetaData.toBool(v);
                continue;
            }
            if (k.equals("TXTINDEX")) {
                this.textindex = MetaData.toBool(v);
                continue;
            }
            if (k.equals("ATVINDEX")) {
                this.attrindex = MetaData.toBool(v);
                continue;
            }
            if (k.equals("FTXINDEX")) {
                this.ftxtindex = MetaData.toBool(v);
                continue;
            }
            if (k.equals("CRTTXT")) {
                this.createtext = MetaData.toBool(v);
                continue;
            }
            if (k.equals("CRTATV")) {
                this.createattr = MetaData.toBool(v);
                continue;
            }
            if (k.equals("CRTFTX")) {
                this.createftxt = MetaData.toBool(v);
                continue;
            }
            if (k.equals("WCINDEX")) {
                this.wcindex = MetaData.toBool(v);
                continue;
            }
            if (k.equals("FTSTEM")) {
                this.stemming = MetaData.toBool(v);
                continue;
            }
            if (k.equals("FTCS")) {
                this.casesens = MetaData.toBool(v);
                continue;
            }
            if (k.equals("UPTODATE")) {
                this.uptodate = MetaData.toBool(v);
                continue;
            }
            if (!k.equals("PTHINDEX") || MetaData.toBool(v)) continue;
            this.uptodate = false;
        }
        if (!storage.equals("7.8") && new Version(storage).compareTo(new Version("7.8")) > 0) {
            throw new BuildException(Text.H_DB_FORMAT, storage);
        }
        this.oldindex = !istorage.equals("7.8") && new Version(istorage).compareTo(new Version("7.8")) > 0;
        this.corrupt = this.dbfile("upd").exists();
        if (this.wcindex) {
            this.ftxtindex = false;
        }
    }

    void write(DataOutput out) throws IOException {
        MetaData.writeInfo(out, "STORAGE", "7.8");
        MetaData.writeInfo(out, "FNAME", this.original);
        MetaData.writeInfo(out, "TIME", this.time);
        MetaData.writeInfo(out, "ISTORAGE", "7.8");
        MetaData.writeInfo(out, "FSIZE", this.filesize);
        MetaData.writeInfo(out, "NDOCS", this.ndocs);
        MetaData.writeInfo(out, "ENCODING", this.encoding);
        MetaData.writeInfo(out, "SIZE", this.size);
        MetaData.writeInfo(out, "CHOPPED", this.chop);
        MetaData.writeInfo(out, "UPDINDEX", this.updindex);
        MetaData.writeInfo(out, "TXTINDEX", this.textindex);
        MetaData.writeInfo(out, "ATVINDEX", this.attrindex);
        MetaData.writeInfo(out, "FTXINDEX", this.ftxtindex);
        MetaData.writeInfo(out, "CRTTXT", this.createtext);
        MetaData.writeInfo(out, "CRTATV", this.createattr);
        MetaData.writeInfo(out, "CRTFTX", this.createftxt);
        MetaData.writeInfo(out, "FTSTEM", this.stemming);
        MetaData.writeInfo(out, "FTCS", this.casesens);
        MetaData.writeInfo(out, "FTDC", this.diacritics);
        MetaData.writeInfo(out, "FTSTOP", this.stopwords);
        MetaData.writeInfo(out, "MAXLEN", this.maxlen);
        MetaData.writeInfo(out, "MAXCATS", this.maxcats);
        MetaData.writeInfo(out, "UPTODATE", this.uptodate);
        MetaData.writeInfo(out, "LASTID", this.lastid);
        if (this.language != null) {
            MetaData.writeInfo(out, "FTLANG", this.language.toString());
        }
        out.writeToken(Token.token("PERM"));
        this.users.write(out);
        out.write(0);
    }

    public void update() {
        this.time = System.currentTimeMillis();
        this.uptodate = false;
        this.dirty = true;
        if (!this.updindex) {
            this.textindex = false;
            this.attrindex = false;
        }
        this.ftxtindex = false;
    }

    private static boolean toBool(String v) {
        return "1".equals(v);
    }

    private static void writeInfo(DataOutput out, String k, boolean v) throws IOException {
        MetaData.writeInfo(out, k, v ? "1" : "0");
    }

    private static void writeInfo(DataOutput out, String k, long v) throws IOException {
        MetaData.writeInfo(out, k, Long.toString(v));
    }

    private static void writeInfo(DataOutput out, String k, String v) throws IOException {
        out.writeToken(Token.token(k));
        out.writeToken(Token.token(v));
    }
}

