/*
 * Decompiled with CFR 0.152.
 */
package org.basex.data;

import java.io.IOException;
import java.util.Arrays;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.data.Namespaces;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.util.Array;
import org.basex.util.TokenBuilder;

final class NSNode {
    NSNode[] children;
    int size;
    NSNode parent;
    int[] values;
    int pre;

    NSNode(int p) {
        this.values = new int[0];
        this.children = new NSNode[0];
        this.pre = p;
    }

    NSNode(DataInput in, NSNode p) throws IOException {
        this.parent = p;
        this.pre = in.readNum();
        this.values = in.readNums();
        this.size = in.readNum();
        this.children = new NSNode[this.size];
        for (int c = 0; c < this.size; ++c) {
            this.children[c] = new NSNode(in, this);
        }
    }

    void write(DataOutput out) throws IOException {
        out.writeNum(this.pre);
        out.writeNums(this.values);
        out.writeNum(this.size);
        for (int c = 0; c < this.size; ++c) {
            this.children[c].write(out);
        }
    }

    void add(NSNode n) {
        int s;
        if (this.size == this.children.length) {
            this.children = Array.copy(this.children, new NSNode[Array.newSize(this.size)]);
        }
        if ((s = this.find(n.pre)) < 0 || n.pre != this.children[s].pre) {
            ++s;
        }
        System.arraycopy(this.children, s, this.children, s + 1, this.size++ - s);
        this.children[s] = n;
        n.parent = this;
    }

    void add(int p, int u) {
        int s = this.values.length;
        this.values = Arrays.copyOf(this.values, s + 2);
        this.values[s] = p;
        this.values[s + 1] = u;
    }

    void delete(int uri) {
        for (int c = 0; c < this.size; ++c) {
            this.children[c].delete(uri);
        }
        int vl = this.values.length;
        for (int v = 0; v < vl; v += 2) {
            if (this.values[v + 1] != uri) continue;
            int[] vals = new int[vl - 2];
            System.arraycopy(this.values, 0, vals, 0, v);
            System.arraycopy(this.values, v + 2, vals, v, vl - v - 2);
            this.values = vals;
            break;
        }
    }

    NSNode find(int p, Data d) {
        int s = this.find(p);
        if (s == -1) {
            return this;
        }
        NSNode ch = this.children[s];
        int cp = ch.pre;
        if (cp == p) {
            return ch;
        }
        if (cp + d.size(cp, 1) <= p) {
            return this;
        }
        return this.children[s].find(p, d);
    }

    int find(int p) {
        int l = 0;
        int h = this.size - 1;
        while (l <= h) {
            int m = l + h >>> 1;
            int v = this.children[m].pre;
            if (v == p) {
                return m;
            }
            if (v < p) {
                l = m + 1;
                continue;
            }
            h = m - 1;
        }
        return l - 1;
    }

    int uri(int p) {
        for (int v = 0; v < this.values.length; v += 2) {
            if (this.values[v] != p) continue;
            return this.values[v + 1];
        }
        return 0;
    }

    void delete(int p, int sz) {
        int s = this.find(p);
        if (s == -1 || this.children[s].pre != p) {
            ++s;
        }
        int upper = p + sz;
        int num = 0;
        int i = s;
        while (i < this.size && this.children[i].pre < upper) {
            ++i;
            ++num;
        }
        this.size -= num;
        if (this.size == 0) {
            this.children = new NSNode[0];
        } else if (num > 0) {
            System.arraycopy(this.children, s + num, this.children, s, this.size - s);
        }
    }

    String print(Namespaces ns, int s, int e) {
        TokenBuilder tb = new TokenBuilder();
        this.print(tb, 0, ns, s, e);
        return tb.toString();
    }

    private void print(TokenBuilder tb, int l, Namespaces ns, int s, int e) {
        if (this.pre >= s && this.pre <= e) {
            int i;
            tb.add(Text.NL);
            for (i = 0; i < l; ++i) {
                tb.add("  ");
            }
            tb.add(this.toString() + ' ');
            for (i = 0; i < this.values.length; i += 2) {
                tb.add("xmlns");
                byte[] p = ns.prefix(this.values[i]);
                if (p.length != 0) {
                    tb.add(58);
                }
                tb.add(p).add("=\"").add(ns.uri(this.values[i + 1])).add("\" ");
            }
        }
        for (int c = 0; c < this.size; ++c) {
            this.children[c].print(tb, l + 1, ns, s, e);
        }
    }

    public String toString() {
        return "Pre[" + this.pre + ']';
    }
}

