/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.basex.core.BaseXException;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.InfoListener;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.core.cmd.Find;
import org.basex.core.cmd.Set;
import org.basex.core.cmd.XQuery;
import org.basex.core.parse.CommandParser;
import org.basex.core.parse.PasswordReader;
import org.basex.data.Data;
import org.basex.data.Namespaces;
import org.basex.data.Nodes;
import org.basex.data.Result;
import org.basex.gui.AGUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIInput;
import org.basex.gui.GUIMacOSX;
import org.basex.gui.GUIMenu;
import org.basex.gui.GUIMenuCmd;
import org.basex.gui.GUIOptions;
import org.basex.gui.GUIStatus;
import org.basex.gui.GUIToolBar;
import org.basex.gui.dialog.DialogPass;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.TableLayout;
import org.basex.gui.view.ViewContainer;
import org.basex.gui.view.ViewNotifier;
import org.basex.gui.view.editor.EditorView;
import org.basex.gui.view.explore.ExploreView;
import org.basex.gui.view.folder.FolderView;
import org.basex.gui.view.info.InfoView;
import org.basex.gui.view.map.MapView;
import org.basex.gui.view.plot.PlotView;
import org.basex.gui.view.table.TableView;
import org.basex.gui.view.text.TextView;
import org.basex.gui.view.tree.TreeView;
import org.basex.io.IOUrl;
import org.basex.io.out.ArrayOutput;
import org.basex.query.QueryException;
import org.basex.util.Performance;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.Version;
import org.basex.util.options.Option;
import org.basex.util.options.StringsOption;

public final class GUI
extends AGUI {
    public final ViewNotifier notify;
    public final GUIStatus status;
    public final GUIInput input;
    public final AbstractButton filter;
    public final EditorView editor;
    public final InfoView info;
    public boolean painting;
    public boolean updating;
    public boolean fullscreen;
    private final GUIMenu menu;
    public final BaseXBack buttons;
    public final BaseXBack nav;
    private final ViewContainer views;
    private final AbstractButton hist;
    private final AbstractButton go;
    private final AbstractButton stop;
    private final BaseXCombo mode;
    private final TextView text;
    private final BaseXBack top;
    private final BaseXBack control;
    private final BaseXLabel hits;
    private final GUIToolBar toolbar;
    private Command command;
    private int menuHeight;
    private JFrame fullscr;
    private int threadID;
    private static final PasswordReader READER = new PasswordReader(){

        @Override
        public String password() {
            DialogPass dp = new DialogPass();
            return dp.ok() ? Token.md5(dp.pass()) : "";
        }
    };
    private final InfoListener infoListener = new InfoListener(){

        @Override
        public void info(String inf) {
            GUI.this.info.setInfo(inf, null, true, false);
        }
    };

    public GUI(Context ctx, GUIOptions opts) {
        super(ctx, opts);
        GUIMacOSX.enableOSXFullscreen(this);
        Dimension scr = Toolkit.getDefaultToolkit().getScreenSize();
        int[] ps = this.gopts.get(GUIOptions.GUILOC);
        int[] sz = this.gopts.get(GUIOptions.GUISIZE);
        int x = Math.max(0, Math.min(scr.width - sz[0], ps[0]));
        int y = Math.max(0, Math.min(scr.height - sz[1], ps[1]));
        this.setBounds(x, y, sz[0], sz[1]);
        if (this.gopts.get(GUIOptions.MAXSTATE).booleanValue()) {
            this.setExtendedState(2);
            this.setExtendedState(4);
            this.setExtendedState(6);
        }
        this.top = new BaseXBack(new BorderLayout());
        this.control = new BaseXBack(new BorderLayout());
        this.menu = new GUIMenu(this);
        this.setJMenuBar(this.menu);
        this.buttons = new BaseXBack(new BorderLayout());
        this.toolbar = new GUIToolBar(GUIConstants.TOOLBAR, this);
        this.buttons.add((Component)this.toolbar, "West");
        this.hits = new BaseXLabel(" ");
        this.hits.setFont(this.hits.getFont().deriveFont(18.0f));
        this.hits.setHorizontalAlignment(4);
        BaseXBack b = new BaseXBack();
        b.add(this.hits);
        this.buttons.add((Component)b, "East");
        if (this.gopts.get(GUIOptions.SHOWBUTTONS).booleanValue()) {
            this.control.add((Component)this.buttons, "Center");
        }
        this.nav = new BaseXBack(new BorderLayout(5, 0)).border(2, 2, 0, 2);
        this.mode = new BaseXCombo((Window)this, Text.FIND, Text.XQUERY, Text.COMMAND);
        this.mode.setSelectedIndex(2);
        this.mode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int s = GUI.this.mode.getSelectedIndex();
                if (s == GUI.this.gopts.get(GUIOptions.SEARCHMODE) || !GUI.this.mode.isEnabled()) {
                    return;
                }
                GUI.this.gopts.set(GUIOptions.SEARCHMODE, s);
                GUI.this.input.mode(GUI.this.mode.getSelectedItem());
                GUI.this.refreshControls();
            }
        });
        this.nav.add((Component)this.mode, "West");
        this.input = new GUIInput(this);
        this.input.mode(this.mode.getSelectedItem());
        this.hist = BaseXButton.get("c_hist", Text.INPUT_HISTORY, false, this);
        this.hist.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[] hs;
                final JPopupMenu pop = new JPopupMenu();
                ActionListener al = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ac) {
                        GUI.this.input.setText(ac.getActionCommand());
                        GUI.this.input.requestFocusInWindow();
                        pop.setVisible(false);
                    }
                };
                int i = GUI.this.context.data() == null ? 2 : GUI.this.gopts.get(GUIOptions.SEARCHMODE);
                for (String en : hs = GUI.this.gopts.get(i == 0 ? GUIOptions.SEARCH : (i == 1 ? GUIOptions.XQUERY : GUIOptions.COMMANDS))) {
                    JMenuItem jmi = new JMenuItem(en);
                    jmi.addActionListener(al);
                    pop.add(jmi);
                }
                pop.show(GUI.this.hist, 0, GUI.this.hist.getHeight());
            }
        });
        b = new BaseXBack(new BorderLayout(5, 0));
        b.add((Component)this.hist, "West");
        b.add((Component)this.input, "Center");
        this.nav.add((Component)b, "Center");
        this.stop = BaseXButton.get("c_stop", Text.STOP, false, this);
        this.stop.setEnabled(false);
        this.stop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GUI.this.command != null) {
                    GUI.this.command.stop();
                    GUI.this.stop.setEnabled(false);
                }
            }
        });
        this.go = BaseXButton.get("c_go", Text.RUN_QUERY, false, this);
        this.go.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUI.this.execute();
            }
        });
        this.filter = BaseXButton.command(GUIMenuCmd.C_FILTER, this);
        b = new BaseXBack(new TableLayout(1, 3, 1, 0));
        b.add(this.stop);
        b.add(this.go);
        b.add(this.filter);
        this.nav.add((Component)b, "East");
        if (this.gopts.get(GUIOptions.SHOWINPUT).booleanValue()) {
            this.control.add((Component)this.nav, "South");
        }
        this.top.add((Component)this.control, "North");
        this.notify = new ViewNotifier(this);
        this.text = new TextView(this.notify);
        this.editor = new EditorView(this.notify);
        this.info = new InfoView(this.notify);
        this.views = new ViewContainer(this, this.text, this.editor, this.info, new FolderView(this.notify), new PlotView(this.notify), new TableView(this.notify), new MapView(this.notify), new TreeView(this.notify), new ExploreView(this.notify));
        this.top.add((Component)this.views, "Center");
        this.setContentBorder();
        this.status = new GUIStatus(this);
        if (this.gopts.get(GUIOptions.SHOWSTATUS).booleanValue()) {
            this.top.add((Component)this.status, "South");
        }
        this.setDefaultCloseOperation(2);
        this.add(this.top);
        this.setVisible(true);
        this.views.updateViews();
        this.refreshControls();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GUI.this.checkVersion();
            }
        });
        this.input.requestFocusInWindow();
    }

    @Override
    public void dispose() {
        if (!this.editor.confirm()) {
            return;
        }
        boolean max = this.getExtendedState() == 6;
        this.gopts.set(GUIOptions.MAXSTATE, max);
        if (!max) {
            this.gopts.set(GUIOptions.GUILOC, new int[]{this.getX(), this.getY()});
            this.gopts.set(GUIOptions.GUISIZE, new int[]{this.getWidth(), this.getHeight()});
        }
        super.dispose();
        this.gopts.write();
        this.context.close();
    }

    void execute() {
        String in = this.input.getText().trim();
        boolean cmd = this.mode.getSelectedIndex() == 2;
        boolean exc = in.startsWith("!");
        if (cmd || exc) {
            try {
                CommandParser cp = new CommandParser(in.substring(exc ? 1 : 0), this.context);
                cp.pwReader(READER);
                this.execute(false, cp.parse());
            }
            catch (QueryException ex) {
                if (!this.info.visible()) {
                    GUIMenuCmd.C_SHOWINFO.execute(this);
                }
                this.info.setInfo(Util.message(ex), null, false, true);
            }
        } else if (this.gopts.get(GUIOptions.SEARCHMODE) == 1 || in.startsWith("/")) {
            this.xquery(in, false);
        } else {
            this.execute(false, new Find(in, this.gopts.get(GUIOptions.FILTERRT)));
        }
    }

    public void xquery(String qu, boolean edit) {
        Data data = this.context.data();
        Namespaces ns = data.nspaces;
        String in = qu.trim().isEmpty() ? "()" : qu;
        int u = ns.uri(Token.EMPTY, 0, data);
        if (u != 0) {
            in = Util.info("declare default element namespace \"%\"; %", ns.uri(u), in);
        }
        this.execute(edit, new XQuery(in));
    }

    public void execute(Command cmd) {
        this.execute(false, cmd);
    }

    public void execute(final boolean edit, final Command ... cmd) {
        if (this.updating) {
            return;
        }
        Thread t = new Thread(){

            @Override
            public void run() {
                if (cmd.length == 0) {
                    GUI.this.info.setInfo("", null, true, true);
                }
                for (Command c : cmd) {
                    if (!GUI.this.exec(c, edit)) break;
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exec(Command cmd, boolean edit) {
        Command c;
        int thread = ++this.threadID;
        while ((c = this.command) != null) {
            c.stop();
            Thread.yield();
            if (this.threadID == thread) continue;
            return true;
        }
        this.cursor(GUIConstants.CURSORWAIT);
        this.input.setCursor(GUIConstants.CURSORWAIT);
        this.stop.setEnabled(true);
        boolean ok = true;
        try {
            Performance perf = new Performance();
            Data data = this.context.data();
            if (this.gopts.get(GUIOptions.FILTERRT).booleanValue() && data != null && !this.context.root()) {
                this.context.update();
            }
            Nodes current = this.context.current();
            this.command = cmd;
            ArrayOutput ao = new ArrayOutput();
            ao.setLimit(this.gopts.get(GUIOptions.MAXTEXT));
            this.updating = cmd.updating(this.context);
            if (edit) {
                this.editor.start();
            }
            if (cmd.newData(this.context)) {
                this.notify.init();
            }
            cmd.listen(this.infoListener);
            String inf = null;
            Throwable cause = null;
            try {
                cmd.execute(this.context, ao);
                inf = cmd.info();
            }
            catch (BaseXException ex) {
                System.out.println("=> " + ex);
                cause = ex.getCause();
                if (cause == null) {
                    cause = ex;
                }
                ok = false;
                inf = Util.message(ex);
            }
            finally {
                this.updating = false;
            }
            String time = perf.getTime();
            this.info.setInfo(inf, cmd, time, ok, true);
            boolean stopped = inf.endsWith(Text.INTERRUPTED);
            if (edit) {
                this.editor.info(cause, stopped, true);
            }
            if (!ok && !stopped) {
                this.text.setText(ao);
                if (!(edit && !inf.startsWith("Improper use? Potential bug? Your feedback is welcome:") || this.info.visible())) {
                    GUIMenuCmd.C_SHOWINFO.execute(this);
                }
            } else {
                Nodes nodes;
                Result result = cmd.result();
                Nodes nodes2 = nodes = result instanceof Nodes && result.size() != 0L ? (Nodes)result : null;
                if (this.context.data() != data) {
                    this.notify.init();
                } else if (cmd.updated(this.context)) {
                    this.notify.update();
                    if (nodes == null) {
                        nodes = this.context.current();
                    }
                } else if (result != null) {
                    boolean flt = this.gopts.get(GUIOptions.FILTERRT);
                    Nodes nd = this.context.current();
                    if (flt || nd != null && !nd.sameAs(current)) {
                        if (nodes != null) {
                            this.notify.context((Nodes)result, flt, null);
                        }
                    } else if (this.context.marked != null) {
                        Nodes m = this.context.marked;
                        if (nodes != null) {
                            m = nodes;
                        } else if (m.size() != 0L) {
                            m = new Nodes(data);
                        }
                        if (this.context.marked != m) {
                            this.notify.mark(m, null);
                        }
                    }
                }
                if (thread == this.threadID && !stopped) {
                    this.status.setText(Util.info(Text.TIME_NEEDED_X, time));
                    if (result != null) {
                        this.setResults(result.size());
                    }
                    if (nodes == null) {
                        if (!this.text.visible() && ao.size() != 0L) {
                            GUIMenuCmd.C_SHOWRESULT.execute(this);
                        }
                        this.text.setText(ao);
                    }
                    this.text.cacheText(ao, cmd, result);
                }
            }
        }
        catch (Exception ex) {
            BaseXDialog.error(this, Util.info(Text.EXEC_ERROR, cmd, Util.bug(ex)));
            this.updating = false;
        }
        this.stop();
        return ok;
    }

    public void stop() {
        if (this.command != null) {
            this.command.stop();
        }
        this.cursor(GUIConstants.CURSORARROW, true);
        this.input.setCursor(GUIConstants.CURSORTEXT);
        this.stop.setEnabled(false);
        this.command = null;
    }

    public <T extends Option<V>, V> void set(T opt, V val) {
        if (!this.context.options.get(opt).toString().equals(val.toString())) {
            Set cmd = new Set(opt, val);
            cmd.run(this.context);
            this.info.setInfo(cmd.info(), cmd, true, false);
        }
    }

    private void setContentBorder() {
        int n = this.control.getComponentCount();
        int n2 = this.top.getComponentCount();
        if (n == 0 && n2 == 2) {
            this.views.border(0);
        } else {
            this.views.setBorder(new CompoundBorder(new EmptyBorder(3, 1, 3, 1), new EtchedBorder()));
        }
    }

    public void updateLayout() {
        GUIConstants.init(this.gopts);
        this.notify.layout();
        this.views.repaint();
    }

    public void updateControl(JComponent comp, boolean show, String layout) {
        if (comp == this.status) {
            if (show) {
                this.top.add((Component)comp, layout);
            } else {
                this.top.remove(comp);
            }
        } else if (comp == this.menu) {
            if (!show) {
                this.menuHeight = this.menu.getHeight();
            }
            int s = show ? this.menuHeight : 0;
            BaseXLayout.setHeight(this.menu, s);
            this.menu.setSize(this.menu.getWidth(), s);
        } else if (show) {
            this.control.add((Component)comp, layout);
        } else {
            this.control.remove(comp);
        }
        this.setContentBorder();
        (this.fullscr == null ? this.getRootPane() : this.fullscr).validate();
        this.refreshControls();
    }

    public void layoutViews() {
        this.views.updateViews();
        this.refreshControls();
        this.repaint();
    }

    public void refreshControls() {
        int i;
        Nodes marked = this.context.marked;
        if (marked != null) {
            this.setResults(marked.size());
        }
        this.filter.setEnabled(marked != null && marked.size() != 0L);
        boolean inf = this.gopts.get(GUIOptions.SHOWINFO);
        this.context.options.set(MainOptions.QUERYINFO, inf);
        this.context.options.set(MainOptions.XMLPLAN, inf);
        Data data = this.context.data();
        int t = this.mode.getSelectedIndex();
        int s = data == null ? 2 : this.gopts.get(GUIOptions.SEARCHMODE);
        this.mode.setEnabled(data != null);
        this.go.setEnabled(s == 2 || this.gopts.get(GUIOptions.EXECRT) == false);
        if (s != t) {
            this.mode.setSelectedIndex(s);
            this.input.mode(this.mode.getSelectedItem());
            this.input.requestFocusInWindow();
        }
        this.toolbar.refresh();
        this.menu.refresh();
        int n = i = this.context.data() == null ? 2 : this.gopts.get(GUIOptions.SEARCHMODE);
        StringsOption options = i == 0 ? GUIOptions.SEARCH : (i == 1 ? GUIOptions.XQUERY : GUIOptions.COMMANDS);
        this.hist.setEnabled(this.gopts.get(options).length != 0);
    }

    private void setResults(long n) {
        int mh = this.context.options.get(MainOptions.MAXHITS);
        if (mh < 0) {
            mh = Integer.MAX_VALUE;
        }
        this.hits.setText(Util.info(Text.RESULTS_X, (n >= (long)mh ? "\u2265" : "") + n));
    }

    public void fullscreen() {
        this.fullscreen ^= true;
        this.fullscreen(this.fullscreen);
    }

    public void fullscreen(boolean full) {
        if (full ^ this.fullscr == null) {
            return;
        }
        if (full) {
            this.control.remove(this.buttons);
            this.control.remove(this.nav);
            this.getRootPane().remove(this.menu);
            this.top.remove(this.status);
            this.remove(this.top);
            this.fullscr = new JFrame();
            this.fullscr.setIconImage(this.getIconImage());
            this.fullscr.setTitle(this.getTitle());
            this.fullscr.setUndecorated(true);
            this.fullscr.setJMenuBar(this.menu);
            this.fullscr.add(this.top);
            this.fullscr.setDefaultCloseOperation(2);
        } else {
            this.fullscr.removeAll();
            this.fullscr.dispose();
            this.fullscr = null;
            if (!this.gopts.get(GUIOptions.SHOWBUTTONS).booleanValue()) {
                this.control.add((Component)this.buttons, "Center");
            }
            if (!this.gopts.get(GUIOptions.SHOWINPUT).booleanValue()) {
                this.control.add((Component)this.nav, "South");
            }
            if (!this.gopts.get(GUIOptions.SHOWSTATUS).booleanValue()) {
                this.top.add((Component)this.status, "South");
            }
            this.setJMenuBar(this.menu);
            this.add(this.top);
        }
        this.gopts.set(GUIOptions.SHOWBUTTONS, !full);
        this.gopts.set(GUIOptions.SHOWINPUT, !full);
        this.gopts.set(GUIOptions.SHOWSTATUS, !full);
        this.fullscreen = full;
        GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().setFullScreenWindow(this.fullscr);
        this.setContentBorder();
        this.refreshControls();
        this.updateControl(this.menu, !full, "North");
        this.setVisible(!full);
    }

    private void checkVersion() {
        Version used;
        Version disk = new Version(this.gopts.get(GUIOptions.UPDATEVERSION));
        if (disk.compareTo(used = new Version(Prop.VERSION.replaceAll(" .*", ""))) < 0) {
            this.gopts.set(GUIOptions.UPDATEVERSION, used.toString());
        } else {
            try {
                Version latest;
                String page = Token.string(new IOUrl(Prop.VERSION_URL).read());
                Matcher m = Pattern.compile("^(Version )?([\\w\\d.]*?)( .*|$)", 32).matcher(page);
                if (m.matches() && disk.compareTo(latest = new Version(m.group(2))) < 0) {
                    if (BaseXDialog.confirm(this, Util.info(Text.H_NEW_VERSION, "BaseX", latest))) {
                        BaseXDialog.browse(this, Prop.UPDATE_URL);
                    } else {
                        this.gopts.set(GUIOptions.UPDATEVERSION, latest.toString());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

