/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui;

import org.basex.core.Context;
import org.basex.core.Text;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.CreateDB;
import org.basex.core.cmd.Cs;
import org.basex.core.cmd.Export;
import org.basex.core.cmd.XQuery;
import org.basex.data.Data;
import org.basex.data.Nodes;
import org.basex.gui.GUI;
import org.basex.gui.GUICommand;
import org.basex.gui.GUIOptions;
import org.basex.gui.dialog.DialogAbout;
import org.basex.gui.dialog.DialogColors;
import org.basex.gui.dialog.DialogEdit;
import org.basex.gui.dialog.DialogExport;
import org.basex.gui.dialog.DialogFonts;
import org.basex.gui.dialog.DialogInsert;
import org.basex.gui.dialog.DialogManage;
import org.basex.gui.dialog.DialogNew;
import org.basex.gui.dialog.DialogPackages;
import org.basex.gui.dialog.DialogPrefs;
import org.basex.gui.dialog.DialogProgress;
import org.basex.gui.dialog.DialogProps;
import org.basex.gui.dialog.DialogServer;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.view.ViewData;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.query.func.Function;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Str;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.IntList;
import org.basex.util.list.StringList;

public enum GUIMenuCmd implements GUICommand
{
    C_CREATE(Text.NEW + "...", "% N", false, false){

        @Override
        public void execute(GUI gui) {
            DialogNew dialog = new DialogNew(gui);
            if (!dialog.ok()) {
                return;
            }
            String in = gui.gopts.get(GUIOptions.INPUTPATH);
            String db = gui.gopts.get(GUIOptions.DBNAME);
            DialogProgress.execute(gui, new CreateDB(db, in.isEmpty() ? null : in));
        }
    }
    ,
    C_OPEN_MANAGE(Text.OPEN_MANAGE + "...", "% M", false, false){

        @Override
        public void execute(GUI gui) {
            if (new DialogManage(gui).nodb() && BaseXDialog.confirm(gui, Text.NEW_DB_QUESTION)) {
                C_CREATE.execute(gui);
            }
        }
    }
    ,
    C_INFO(Text.PROPERTIES + "...", "% D", true, false){

        @Override
        public void execute(GUI gui) {
            new DialogProps(gui);
        }
    }
    ,
    C_EXPORT(Text.EXPORT + "...", null, true, false){

        @Override
        public void execute(GUI gui) {
            DialogExport dialog = new DialogExport(gui);
            if (!dialog.ok()) {
                return;
            }
            IOFile root = new IOFile(dialog.path());
            if (root.exists()) {
                IO file = null;
                boolean overwrite = false;
                Data d = gui.context.data();
                IntList il = d.resources.docs();
                int is = il.size();
                for (int i = 0; i < is; ++i) {
                    file = root.merge(Token.string(d.text(il.get(i), true)));
                    if (!file.exists()) continue;
                    if (overwrite) {
                        file = null;
                        break;
                    }
                    overwrite = true;
                }
                if (overwrite) {
                    String msg;
                    String string = msg = file == null ? Text.FILES_REPLACE_X : Text.FILE_EXISTS_X;
                    if (file == null) {
                        file = root;
                    }
                    if (!BaseXDialog.confirm(gui, Util.info(msg, file))) {
                        return;
                    }
                }
            }
            DialogProgress.execute(gui, new Export(root.path()));
        }
    }
    ,
    C_CLOSE(Text.CLOSE, "% shift W", true, false){

        @Override
        public void execute(GUI gui) {
            gui.execute(new Close());
        }
    }
    ,
    C_SERVER(Text.S_SERVER_ADMIN + "...", null, false, false){

        @Override
        public void execute(GUI gui) {
            new DialogServer(gui);
        }
    }
    ,
    C_EDITNEW(Text.NEW, "% T", false, false){

        @Override
        public void execute(GUI gui) {
            gui.editor.newFile();
        }
    }
    ,
    C_EDITOPEN(Text.OPEN + "...", "% O", false, false){

        @Override
        public void execute(GUI gui) {
            gui.editor.open();
        }
    }
    ,
    C_EDITREOPEN(Text.REOPEN + "...", null, false, false){

        @Override
        public void execute(GUI gui) {
            gui.editor.reopen();
        }

        @Override
        public boolean enabled(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWEDITOR);
        }
    }
    ,
    C_EDITSAVE(Text.SAVE, "% S", false, false){

        @Override
        public void execute(GUI gui) {
            gui.editor.save();
        }

        @Override
        public boolean enabled(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWEDITOR) != false && gui.editor.modified();
        }
    }
    ,
    C_EDITSAVEAS(Text.SAVE_AS + "...", "% shift S", false, false){

        @Override
        public void execute(GUI gui) {
            gui.editor.saveAs();
        }

        @Override
        public boolean enabled(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWEDITOR);
        }
    }
    ,
    C_EDITCLOSE(Text.CLOSE, "% W", false, false){

        @Override
        public void execute(GUI gui) {
            gui.editor.close(null);
        }

        @Override
        public boolean enabled(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWEDITOR);
        }
    }
    ,
    C_NEXTERROR(Text.NEXT_ERROR, "% PERIOD", false, false){

        @Override
        public void execute(GUI gui) {
            gui.editor.jumpToError();
        }

        @Override
        public boolean enabled(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWEDITOR);
        }
    }
    ,
    C_COMMENT(Text.COMMENT, "% K", false, false){

        @Override
        public void execute(GUI gui) {
            gui.editor.getEditor().comment();
        }

        @Override
        public boolean enabled(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWEDITOR);
        }
    }
    ,
    C_FORMAT(Text.FORMAT, "% shift F", false, false){

        @Override
        public void execute(GUI gui) {
            gui.editor.getEditor().format();
        }

        @Override
        public boolean enabled(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWEDITOR);
        }
    }
    ,
    C_SORT(Text.SORT, "% U", false, false){

        @Override
        public void execute(GUI gui) {
            gui.editor.getEditor().sort();
        }

        @Override
        public boolean enabled(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWEDITOR);
        }
    }
    ,
    C_EXIT(Text.EXIT, "% Q", false, false){

        @Override
        public void execute(GUI gui) {
            gui.dispose();
        }
    }
    ,
    C_COPYPATH(Text.COPY_PATH, "% shift C", true, false){

        @Override
        public void execute(GUI gui) {
            int pre = gui.context.marked.pres[0];
            BaseXLayout.copy(Token.string(ViewData.path(gui.context.data(), pre)));
        }

        @Override
        public boolean enabled(GUI gui) {
            Nodes marked = gui.context.marked;
            return marked != null && marked.size() != 0L;
        }
    }
    ,
    C_COPY(Text.COPY, null, true, false){

        @Override
        public void execute(GUI gui) {
            Context ctx = gui.context;
            Nodes n = ctx.marked;
            ctx.copied = new Nodes(n.pres, n.data);
        }

        @Override
        public boolean enabled(GUI gui) {
            return GUIMenuCmd.updatable(gui.context.marked, new int[0]);
        }
    }
    ,
    C_PASTE(Text.PASTE, null, true, false){

        @Override
        public void execute(GUI gui) {
            StringBuilder sb = new StringBuilder();
            Nodes n = gui.context.copied;
            int i = 0;
            while ((long)i < n.size()) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(GUIMenuCmd.openPre(n, i));
                ++i;
            }
            gui.context.copied = null;
            gui.execute(new XQuery("insert nodes (" + sb + ") into " + GUIMenuCmd.openPre(gui.context.marked, 0)));
        }

        @Override
        public boolean enabled(GUI gui) {
            Context ctx = gui.context;
            return GUIMenuCmd.updatable(ctx.marked, new int[]{0}) && ctx.copied != null;
        }
    }
    ,
    C_DELETE(Text.DELETE + "...", null, true, false){

        @Override
        public void execute(GUI gui) {
            if (!BaseXDialog.confirm(gui, Text.DELETE_NODES)) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            Nodes n = gui.context.marked;
            int i = 0;
            while ((long)i < n.size()) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(GUIMenuCmd.openPre(n, i));
                ++i;
            }
            gui.context.marked = new Nodes(n.data);
            gui.context.copied = null;
            gui.context.focused = -1;
            gui.execute(new XQuery("delete nodes (" + sb + ')'));
        }

        @Override
        public boolean enabled(GUI gui) {
            return GUIMenuCmd.updatable(gui.context.marked, new int[0]);
        }
    }
    ,
    C_INSERT(Text.NEW + "...", null, true, false){

        @Override
        public void execute(GUI gui) {
            Nodes n = gui.context.marked;
            DialogInsert insert = new DialogInsert(gui);
            if (!insert.ok()) {
                return;
            }
            StringList sl = insert.result;
            NodeType type = ANode.type(insert.kind);
            String item = Token.string(type.string()) + " { " + GUIMenuCmd.quote(sl.get(0)) + " }";
            if (type == NodeType.ATT || type == NodeType.PI) {
                item = item + " { " + GUIMenuCmd.quote(sl.get(1)) + " }";
            } else if (type == NodeType.ELM) {
                item = item + " { () }";
            }
            gui.context.copied = null;
            gui.execute(new XQuery("insert node " + item + " into " + GUIMenuCmd.openPre(n, 0)));
        }

        @Override
        public boolean enabled(GUI gui) {
            return GUIMenuCmd.updatable(gui.context.marked, new int[]{3, 5, 4, 2});
        }
    }
    ,
    C_EDIT(Text.EDIT + "...", null, true, false){

        @Override
        public void execute(GUI gui) {
            Nodes n = gui.context.marked;
            DialogEdit edit = new DialogEdit(gui, n.pres[0]);
            if (!edit.ok()) {
                return;
            }
            String rename = null;
            String replace = null;
            int k = edit.kind;
            if (k == 1 || k == 5 || k == 3) {
                rename = edit.result.get(0);
                if (k != 1) {
                    replace = edit.result.get(1);
                }
            } else {
                replace = edit.result.get(0);
            }
            if (rename != null) {
                gui.execute(new XQuery("rename node " + GUIMenuCmd.openPre(n, 0) + " as " + GUIMenuCmd.quote(rename)));
            }
            if (replace != null) {
                gui.execute(new XQuery("replace value of node " + GUIMenuCmd.openPre(n, 0) + " with " + GUIMenuCmd.quote(replace)));
            }
        }

        @Override
        public boolean enabled(GUI gui) {
            return GUIMenuCmd.updatable(gui.context.marked, new int[]{0});
        }
    }
    ,
    C_FILTER(Text.FILTER_SELECTED, null, true, false){

        @Override
        public void execute(GUI gui) {
            Context ctx = gui.context;
            Nodes marked = ctx.marked;
            if (marked.size() == 0L) {
                int pre = gui.context.focused;
                if (pre == -1) {
                    return;
                }
                marked = new Nodes(pre, ctx.data());
            }
            gui.notify.context(marked, false, null);
        }

        @Override
        public boolean enabled(GUI gui) {
            Nodes marked = gui.context.marked;
            return marked != null && marked.size() != 0L;
        }
    }
    ,
    C_SHOWEDITOR(Text.EDITOR, "% E", false, true){

        @Override
        public void execute(GUI gui) {
            gui.gopts.invert(GUIOptions.SHOWEDITOR);
            gui.layoutViews();
        }

        @Override
        public boolean selected(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWEDITOR);
        }
    }
    ,
    C_JUMPFILE(Text.JUMP_TO_FILE, "% J", false, false){

        @Override
        public void execute(GUI gui) {
            gui.editor.showProject();
            gui.editor.jumpToFile();
        }

        @Override
        public boolean enabled(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWEDITOR);
        }
    }
    ,
    C_FILESEARCH(Text.FIND_FILES + "...", Prop.MAC ? "% shift H" : "% H", false, false){

        @Override
        public void execute(GUI gui) {
            gui.editor.showProject();
            gui.editor.findFiles();
        }

        @Override
        public boolean enabled(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWEDITOR);
        }
    }
    ,
    C_SHOWPROJECT(Text.PROJECT, "% P", false, true){

        @Override
        public void execute(GUI gui) {
            gui.gopts.invert(GUIOptions.SHOWPROJECT);
            gui.editor.project();
        }

        @Override
        public boolean enabled(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWEDITOR);
        }

        @Override
        public boolean selected(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWPROJECT);
        }
    }
    ,
    C_SHOWINFO(Text.QUERY_INFO, "% I", false, true){

        @Override
        public void execute(GUI gui) {
            gui.gopts.invert(GUIOptions.SHOWINFO);
            gui.layoutViews();
        }

        @Override
        public boolean selected(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWINFO);
        }
    }
    ,
    C_PACKAGES(Text.PACKAGES + "...", null, false, false){

        @Override
        public void execute(GUI gui) {
            new DialogPackages(gui);
        }
    }
    ,
    C_SHOWBUTTONS(Text.BUTTONS, null, false, true){

        @Override
        public void execute(GUI gui) {
            gui.gopts.invert(GUIOptions.SHOWBUTTONS);
            gui.updateControl(gui.buttons, gui.gopts.get(GUIOptions.SHOWBUTTONS), "Center");
        }

        @Override
        public boolean selected(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWBUTTONS);
        }
    }
    ,
    C_SHOWINPUT(Text.INPUT_BAR, null, false, true){

        @Override
        public void execute(GUI gui) {
            gui.updateControl(gui.nav, gui.gopts.invert(GUIOptions.SHOWINPUT), "South");
        }

        @Override
        public boolean selected(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWINPUT);
        }
    }
    ,
    C_SHOWSTATUS(Text.STATUS_BAR, null, false, true){

        @Override
        public void execute(GUI gui) {
            gui.updateControl(gui.status, gui.gopts.invert(GUIOptions.SHOWSTATUS), "South");
        }

        @Override
        public boolean selected(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWSTATUS);
        }
    }
    ,
    C_SHOWRESULT(Text.RESULT, "% R", false, true){

        @Override
        public void execute(GUI gui) {
            gui.gopts.invert(GUIOptions.SHOWTEXT);
            gui.layoutViews();
        }

        @Override
        public boolean selected(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWTEXT);
        }
    }
    ,
    C_SHOWMAP(Text.MAP, "% 1", true, true){

        @Override
        public void execute(GUI gui) {
            gui.gopts.invert(GUIOptions.SHOWMAP);
            gui.layoutViews();
        }

        @Override
        public boolean selected(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWMAP);
        }
    }
    ,
    C_SHOWTREE(Text.TREE, "% 2", true, true){

        @Override
        public void execute(GUI gui) {
            gui.gopts.invert(GUIOptions.SHOWTREE);
            gui.layoutViews();
        }

        @Override
        public boolean selected(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWTREE);
        }
    }
    ,
    C_SHOWFOLDER(Text.FOLDER, "% 3", true, true){

        @Override
        public void execute(GUI gui) {
            gui.gopts.invert(GUIOptions.SHOWFOLDER);
            gui.layoutViews();
        }

        @Override
        public boolean selected(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWFOLDER);
        }
    }
    ,
    C_SHOWPLOT(Text.PLOT, "% 4", true, true){

        @Override
        public void execute(GUI gui) {
            gui.gopts.invert(GUIOptions.SHOWPLOT);
            gui.layoutViews();
        }

        @Override
        public boolean selected(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWPLOT);
        }
    }
    ,
    C_SHOWTABLE(Text.TABLE, "% 5", true, true){

        @Override
        public void execute(GUI gui) {
            gui.gopts.invert(GUIOptions.SHOWTABLE);
            gui.layoutViews();
        }

        @Override
        public boolean selected(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWTABLE);
        }
    }
    ,
    C_SHOWEXPLORE(Text.EXPLORER, "% 6", true, true){

        @Override
        public void execute(GUI gui) {
            gui.gopts.invert(GUIOptions.SHOWEXPLORE);
            gui.layoutViews();
        }

        @Override
        public boolean selected(GUI gui) {
            return gui.gopts.get(GUIOptions.SHOWEXPLORE);
        }
    }
    ,
    C_FULL(Text.FULLSCREEN, Prop.MAC ? "% shift F" : "F11", false, true){

        @Override
        public void execute(GUI gui) {
            gui.fullscreen();
        }

        @Override
        public boolean selected(GUI gui) {
            return gui.fullscreen;
        }
    }
    ,
    C_RTEXEC(Text.RT_EXECUCTION, null, false, true){

        @Override
        public void execute(GUI gui) {
            gui.gopts.invert(GUIOptions.EXECRT);
            gui.stop();
            gui.refreshControls();
            gui.editor.refreshMark();
        }

        @Override
        public boolean selected(GUI gui) {
            return gui.gopts.get(GUIOptions.EXECRT);
        }
    }
    ,
    C_RTFILTER(Text.RT_FILTERING, null, true, true){

        @Override
        public void execute(GUI gui) {
            boolean rt = gui.gopts.invert(GUIOptions.FILTERRT);
            gui.stop();
            gui.refreshControls();
            gui.editor.refreshMark();
            Context ctx = gui.context;
            boolean root = ctx.root();
            Data data = ctx.data();
            if (rt) {
                if (root) {
                    gui.notify.mark(new Nodes(data), null);
                } else {
                    Nodes mark = ctx.marked;
                    ctx.marked = new Nodes(data);
                    gui.notify.context(mark, true, null);
                }
            } else if (!root) {
                gui.notify.context(new Nodes(0, data), true, null);
                gui.notify.mark(ctx.current(), null);
            }
        }

        @Override
        public boolean selected(GUI gui) {
            return gui.gopts.get(GUIOptions.FILTERRT);
        }
    }
    ,
    C_COLOR(Text.COLORS + "...", null, false, false){

        @Override
        public void execute(GUI gui) {
            new DialogColors(gui);
        }
    }
    ,
    C_FONTS(Text.FONTS_D, null, false, false){

        @Override
        public void execute(GUI gui) {
            new DialogFonts(gui);
        }
    }
    ,
    C_PREFS(Text.PREFERENCES + "...", Prop.MAC ? "% COMMA" : "% shift P", false, false){

        @Override
        public void execute(GUI gui) {
            new DialogPrefs(gui);
        }
    }
    ,
    C_HELP(Text.HELP, "F1", false, false){

        @Override
        public void execute(GUI gui) {
            BaseXDialog.browse(gui, Prop.DOC_URL);
        }
    }
    ,
    C_COMMUNITY(Text.COMMUNITY, null, false, false){

        @Override
        public void execute(GUI gui) {
            BaseXDialog.browse(gui, Prop.COMMUNITY_URL);
        }
    }
    ,
    C_UPDATES(Text.CHECK_FOR_UPDATES, null, false, false){

        @Override
        public void execute(GUI gui) {
            BaseXDialog.browse(gui, Prop.UPDATE_URL);
        }
    }
    ,
    C_ABOUT(Text.ABOUT + "...", null, false, false){

        @Override
        public void execute(GUI gui) {
            new DialogAbout(gui);
        }
    }
    ,
    C_GOBACK(Text.GO_BACK, "alt LEFT", true, false){

        @Override
        public void execute(GUI gui) {
            gui.notify.hist(false);
        }

        @Override
        public boolean enabled(GUI gui) {
            return gui.notify.query(true) != null;
        }
    }
    ,
    C_GOFORWARD(Text.GO_FORWARD, "alt RIGHT", true, false){

        @Override
        public void execute(GUI gui) {
            gui.notify.hist(true);
        }

        @Override
        public boolean enabled(GUI gui) {
            return gui.notify.query(false) != null;
        }
    }
    ,
    C_GOUP(Text.GO_UP, "alt UP", true, false){

        @Override
        public void execute(GUI gui) {
            Context ctx = gui.context;
            if (ctx.root()) {
                return;
            }
            boolean doc = true;
            Data data = ctx.data();
            for (int pre : ctx.current().pres) {
                doc &= data.kind(pre) == 0;
            }
            if (doc) {
                ctx.update();
                gui.notify.context(ctx.current(), false, null);
            } else {
                gui.execute(new Cs(".."));
            }
        }

        @Override
        public boolean enabled(GUI gui) {
            return gui.gopts.get(GUIOptions.FILTERRT) == false && gui.context.data() != null && !gui.context.root();
        }
    }
    ,
    C_GOHOME(Text.GO_HOME, "alt HOME", true, false){

        @Override
        public void execute(GUI gui) {
            Context ctx = gui.context;
            if (ctx.root()) {
                return;
            }
            ctx.update();
            gui.notify.context(ctx.current(), false, null);
        }

        @Override
        public boolean enabled(GUI gui) {
            return gui.context.data() != null && !gui.context.root();
        }
    }
    ,
    C_HOME(Text.GO_HOME, null, true, false){

        @Override
        public void execute(GUI gui) {
            gui.execute(new XQuery("/"));
        }
    };

    private final boolean data;
    private final String label;
    private final Object key;
    private final boolean toggle;
    private final String shortcut;

    private GUIMenuCmd(String l, String k, boolean d, boolean t) {
        this.label = l;
        this.key = k;
        this.data = d;
        this.toggle = t;
        this.shortcut = BaseXLayout.addShortcut(l, k);
    }

    @Override
    public boolean enabled(GUI gui) {
        return !this.data || gui.context.data() != null;
    }

    @Override
    public boolean selected(GUI gui) {
        return false;
    }

    @Override
    public final String label() {
        return this.label;
    }

    @Override
    public final boolean toggle() {
        return this.toggle;
    }

    @Override
    public String shortcut() {
        return this.shortcut;
    }

    @Override
    public Object shortcuts() {
        return this.key;
    }

    private static boolean updatable(Nodes n, int ... no) {
        if (n == null || (no.length == 0 ? n.size() < 1L : n.size() != 1L)) {
            return false;
        }
        int k = n.data.kind(n.pres[0]);
        for (int i : no) {
            if (k != i) continue;
            return false;
        }
        return true;
    }

    private static String quote(String s) {
        return '\"' + s.replaceAll("\"", "&quot;") + '\"';
    }

    private static String openPre(Nodes n, int i) {
        return Function._DB_OPEN_PRE.get(null, Str.get(n.data.meta.name), Int.get(n.pres[i])).toString();
    }
}

