/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.SortedMap;
import org.basex.build.CsvOptions;
import org.basex.build.JsonSerialOptions;
import org.basex.core.BaseXException;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXFileChooser;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.TableLayout;
import org.basex.io.IOFile;
import org.basex.io.out.ArrayOutput;
import org.basex.io.serial.SerialMethod;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.util.Util;
import org.basex.util.list.StringList;
import org.basex.util.options.Option;
import org.basex.util.options.Options;
import org.basex.util.options.OptionsOption;

public final class DialogExport
extends BaseXDialog {
    private static final String[] ENCODINGS;
    private final BaseXTextField path;
    private final BaseXLabel info;
    private final BaseXCombo method;
    private final BaseXTextField mparams;
    private final BaseXCombo encoding;
    private final BaseXBack buttons;
    private final BaseXTextField params;

    public DialogExport(GUI main) {
        super(main, Text.EXPORT);
        BaseXBack p = new BaseXBack(new TableLayout(4, 1, 0, 0));
        p.add(new BaseXLabel(Text.OUTPUT_DIR + ":", true, true).border(0, 0, 6, 0));
        BaseXBack pp = new BaseXBack(new TableLayout(1, 2, 8, 0));
        this.path = new BaseXTextField(main.gopts.get(GUIOptions.INPUTPATH), this);
        this.path.history(GUIOptions.INPUTS, this);
        pp.add(this.path);
        BaseXButton browse = new BaseXButton(Text.BROWSE_D, this);
        browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogExport.this.choose();
            }
        });
        pp.add(browse);
        p.add(pp);
        MainOptions opts = this.gui.context.options;
        SerializerOptions sopts = opts.get(MainOptions.EXPORTER);
        StringList sl = new StringList();
        for (SerialMethod sm : SerialMethod.values()) {
            sl.add(sm.name());
        }
        sl.deleteAt(sl.size() - 1);
        this.method = new BaseXCombo((Window)this, sl.toArray());
        this.method.setSelectedItem(sopts.get(SerializerOptions.METHOD).name());
        this.mparams = new BaseXTextField(this);
        BaseXLayout.setWidth(this.mparams, 233);
        BaseXBack mth = new BaseXBack(new TableLayout(1, 2, 8, 0));
        mth.add(this.method);
        mth.add(this.mparams);
        this.encoding = new BaseXCombo((Window)this, ENCODINGS);
        String enc = sopts.get(SerializerOptions.ENCODING);
        boolean f = false;
        for (String s : ENCODINGS) {
            f |= s.equals(enc);
        }
        if (!f) {
            enc = enc.toUpperCase(Locale.ENGLISH);
            for (String s : ENCODINGS) {
                f |= s.equals(enc);
            }
        }
        this.encoding.setSelectedItem(f ? enc : sopts.get(SerializerOptions.ENCODING));
        this.params = new BaseXTextField(sopts.toString(), this);
        this.params.setToolTipText(DialogExport.tooltip(Serializer.OPTIONS));
        pp = new BaseXBack(new TableLayout(3, 2, 16, 6)).border(8, 0, 8, 0);
        pp.add(new BaseXLabel(Text.METHOD + ":", true, true));
        pp.add(mth);
        pp.add(new BaseXLabel(Text.ENCODING + ":", true, true));
        pp.add(this.encoding);
        pp.add(new BaseXLabel(Text.PARAMETERS + ":", true, true));
        pp.add(this.params);
        p.add(pp);
        this.info = new BaseXLabel(" ").border(8, 0, 0, 0);
        p.add(this.info);
        this.set(p, "Center");
        pp = new BaseXBack(new BorderLayout());
        this.buttons = this.okCancel();
        pp.add((Component)this.buttons, "East");
        this.set(pp, "South");
        this.action(this.method);
        this.finish(null);
    }

    static BaseXCombo encoding(BaseXDialog dialog, String encoding) {
        BaseXCombo cb = new BaseXCombo((Window)dialog, ENCODINGS);
        boolean f = false;
        String enc = encoding == null ? "UTF-8" : encoding;
        for (String s : ENCODINGS) {
            f |= s.equals(enc);
        }
        if (!f) {
            enc = enc.toUpperCase(Locale.ENGLISH);
            for (String s : ENCODINGS) {
                f |= s.equals(enc);
            }
        }
        cb.setSelectedItem(enc);
        return cb;
    }

    private void choose() {
        IOFile io = new BaseXFileChooser(Text.CHOOSE_DIR, this.path.getText(), this.gui).select(BaseXFileChooser.Mode.DOPEN);
        if (io != null) {
            this.path.setText(io.path());
        }
    }

    public String path() {
        return this.path.getText().trim();
    }

    @Override
    public void action(Object comp) {
        String pth = this.path();
        IOFile io = new IOFile(pth);
        String inf = io.isDir() && io.children().length > 0 ? Text.DIR_NOT_EMPTY : null;
        this.ok = !pth.isEmpty();
        SerialMethod mth = SerialMethod.valueOf(this.method.getSelectedItem());
        OptionsOption<JsonSerialOptions> opts = mth == SerialMethod.JSON ? SerializerOptions.JSON : (mth == SerialMethod.CSV ? SerializerOptions.CSV : null);
        boolean showmparams = opts != null;
        this.mparams.setEnabled(showmparams);
        if (this.ok) {
            this.gui.gopts.set(GUIOptions.INPUTPATH, pth);
            try {
                if (comp == this.method) {
                    if (showmparams) {
                        JsonSerialOptions mopts = this.options(null).get(opts);
                        this.mparams.setToolTipText(DialogExport.tooltip(mopts));
                        this.mparams.setText(mopts.toString());
                    } else {
                        this.mparams.setToolTipText(null);
                        this.mparams.setText("");
                    }
                }
                Serializer.get(new ArrayOutput(), this.options(mth));
            }
            catch (IOException ex) {
                this.ok = false;
                inf = ex.getMessage();
            }
        }
        this.info.setText(inf, this.ok ? GUIConstants.Msg.WARN : GUIConstants.Msg.ERROR);
        DialogExport.enableOK(this.buttons, Text.B_OK, this.ok);
    }

    @Override
    public void close() {
        if (!this.ok) {
            return;
        }
        SerialMethod mth = SerialMethod.valueOf(this.method.getSelectedItem());
        try {
            this.gui.set(MainOptions.EXPORTER, this.options(mth));
        }
        catch (BaseXException ex) {
            throw Util.notExpected(ex);
        }
        super.close();
        this.path.store();
    }

    private SerializerOptions options(SerialMethod mth) throws BaseXException {
        SerializerOptions sopts = new SerializerOptions();
        sopts.parse(this.params.getText());
        sopts.set(SerializerOptions.METHOD, SerialMethod.valueOf(this.method.getSelectedItem()));
        sopts.set(SerializerOptions.ENCODING, this.encoding.getSelectedItem());
        if (mth == SerialMethod.JSON) {
            JsonSerialOptions jopts = new JsonSerialOptions();
            jopts.parse(this.mparams.getText());
            sopts.set(SerializerOptions.JSON, jopts);
        } else if (mth == SerialMethod.CSV) {
            CsvOptions copts = new CsvOptions();
            copts.parse(this.mparams.getText());
            sopts.set(SerializerOptions.CSV, copts);
        }
        return sopts;
    }

    private static String tooltip(Options opts) {
        StringBuilder sb = new StringBuilder("<html><b>").append(Text.PARAMETERS).append(":</b><br>");
        for (Option<?> so : opts) {
            if (so instanceof OptionsOption) continue;
            sb.append("\u2022 ").append(so).append("<br/>");
        }
        return sb.append("</html>").toString();
    }

    static {
        SortedMap<String, Charset> cs = Charset.availableCharsets();
        ENCODINGS = cs.keySet().toArray(new String[cs.size()]);
    }
}

