/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.basex.BaseXServer;
import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.Databases;
import org.basex.core.Perm;
import org.basex.core.Text;
import org.basex.core.cmd.Exit;
import org.basex.core.cmd.ShowSessions;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIOptions;
import org.basex.gui.dialog.DialogUser;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXPassword;
import org.basex.gui.layout.BaseXTabs;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.TableLayout;
import org.basex.gui.text.SearchEditor;
import org.basex.gui.text.TextPanel;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.server.ClientSession;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class DialogServer
extends BaseXDialog {
    private final BaseXPassword admpass;
    final BaseXTabs tabs;
    private final DialogUser user = new DialogUser(true, this);
    private final DialogUser dbsP = new DialogUser(false, this);
    private final BaseXBack databases = this.dbsP.getTablePanel();
    private final BaseXBack sess = new BaseXBack();
    private final BaseXBack logs = new BaseXBack();
    final BaseXTextField admuser;
    final BaseXButton disconnect;
    private final BaseXButton refreshSess;
    private final BaseXButton connect;
    private final BaseXButton start;
    private int tab;
    private final Context ctx;
    private final BaseXButton refreshLog;
    private final BaseXButton stop;
    private final BaseXButton delete;
    private final BaseXButton deleteAll;
    private final BaseXTextField host;
    private final BaseXTextField ports;
    private final BaseXTextField portc;
    private final TextPanel sese;
    private final TextPanel logt;
    private final BaseXLabel infoC;
    private final BaseXLabel infoL;
    private final BaseXCombo logc;
    private final IOFile logd;
    private ClientSession cs;
    private boolean running;
    private boolean connected;

    public DialogServer(GUI main) {
        super(main, Text.S_SERVER_ADMIN);
        this.ctx = this.gui.context;
        this.logd = this.ctx.globalopts.dbpath(".logs");
        this.databases.border(8);
        BaseXBack conn = new BaseXBack(new BorderLayout(0, 32)).border(8);
        this.start = new BaseXButton(Text.START, this);
        this.stop = new BaseXButton(Text.STOP, this);
        this.connect = new BaseXButton(Text.CONNECT, this);
        this.disconnect = new BaseXButton(Text.DISCONNECT, this);
        GUIOptions gopts = this.gui.gopts;
        this.host = new BaseXTextField(gopts.get(GUIOptions.S_HOST), this);
        this.ports = new BaseXTextField(Integer.toString(gopts.get(GUIOptions.S_SERVERPORT)), this);
        this.portc = new BaseXTextField(Integer.toString(gopts.get(GUIOptions.S_PORT)), this);
        this.admuser = new BaseXTextField(gopts.get(GUIOptions.S_USER), this);
        this.admpass = new BaseXPassword(this);
        this.infoC = new BaseXLabel(" ").border(12, 0, 0, 0);
        BaseXBack p = new BaseXBack(new TableLayout(6, 1, 0, 0));
        p.add(new BaseXLabel(Text.S_LOCALSERVER + ": ", true, true));
        BaseXBack pp = new BaseXBack(new TableLayout(2, 2, 8, 4)).border(0, 0, 0, 0);
        pp.add(new BaseXLabel(Text.S_PORT + ": "));
        pp.add(this.ports);
        pp.add(new BaseXLabel());
        BaseXBack ppp = new BaseXBack(new TableLayout(1, 2, 5, 0));
        ppp.add(this.start);
        ppp.add(this.stop);
        pp.add(ppp);
        p.add(pp);
        p.add(new BaseXLabel());
        p.add(new BaseXLabel(Text.S_ADLOGIN + ": ", true, true).border(12, 0, 6, 0));
        pp = new BaseXBack(new TableLayout(5, 2, 8, 4));
        pp.add(new BaseXLabel(Text.USERNAME + ": "));
        pp.add(this.admuser);
        pp.add(new BaseXLabel(Text.PASSWORD + ": "));
        pp.add(this.admpass);
        pp.add(new BaseXLabel(Text.S_HOST + ": "));
        pp.add(this.host);
        pp.add(new BaseXLabel(Text.S_PORT + ": "));
        pp.add(this.portc);
        pp.add(new BaseXLabel());
        ppp = new BaseXBack(new TableLayout(1, 2, 5, 0));
        ppp.add(this.connect);
        ppp.add(this.disconnect);
        pp.add(ppp);
        p.add(pp);
        p.add(this.infoC);
        conn.add((Component)p, "Center");
        p = new BaseXBack(new TableLayout(2, 1));
        BaseXLabel l = new BaseXLabel(Text.S_INFO1);
        l.setForeground(GUIConstants.DGRAY);
        p.add(l);
        l = new BaseXLabel(Text.S_INFO2);
        l.setForeground(GUIConstants.DGRAY);
        p.add(l);
        conn.add((Component)p, "South");
        this.sess.border(8).layout(new BorderLayout());
        this.sese = new TextPanel(false, this);
        this.sese.setFont(this.start.getFont());
        this.refreshSess = new BaseXButton(Text.REFRESH, this);
        pp = new BaseXBack(new BorderLayout());
        pp.add((Component)new BaseXLabel(Text.S_SESSIONS + ": ", false, true), "North");
        pp.add((Component)new SearchEditor(main, this.sese), "Center");
        p.add(pp);
        this.sess.add((Component)pp, "Center");
        p = new BaseXBack(new BorderLayout(0, 0));
        p.add((Component)this.refreshSess, "East");
        this.sess.add((Component)p, "South");
        this.logs.border(8).layout(new BorderLayout());
        this.delete = new BaseXButton(Text.DELETE, this);
        this.deleteAll = new BaseXButton(Text.DELETE_ALL, this);
        this.logc = new BaseXCombo((Window)this, new String[0]);
        this.logt = new TextPanel(false, this);
        this.logt.setFont(this.start.getFont());
        BaseXLayout.setHeight(this.logt, 100);
        this.logt.border(5);
        this.infoL = new BaseXLabel(" ").border(12, 0, 0, 0);
        this.refreshLog = new BaseXButton(Text.REFRESH, this);
        p = new BaseXBack(new BorderLayout());
        pp = new BaseXBack();
        pp.add(this.logc);
        pp.add(this.delete);
        pp.add(this.deleteAll);
        p.add((Component)pp, "West");
        this.logs.add((Component)p, "North");
        this.logs.add((Component)new SearchEditor(main, this.logt), "Center");
        p = new BaseXBack(new BorderLayout(8, 0));
        p.add((Component)this.infoL, "West");
        p.add((Component)this.refreshLog, "East");
        this.logs.add((Component)p, "South");
        this.tabs = new BaseXTabs(this);
        this.tabs.add(Text.S_CONNECT, conn);
        this.tabs.add(Text.USERS, this.user);
        this.tabs.add(Text.DATABASES, this.databases);
        this.tabs.add(Text.S_SESSIONS, this.sess);
        this.tabs.add(Text.S_LOCALLOGS, this.logs);
        this.set(this.tabs, "Center");
        this.running = this.ping(true);
        this.tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                BaseXTabs pane = (BaseXTabs)evt.getSource();
                DialogServer.this.tab = pane.getSelectedIndex();
                Component o = pane.getSelectedComponent();
                if (o == DialogServer.this.logs) {
                    DialogServer.this.refreshLog();
                }
                if (o == DialogServer.this.user) {
                    DialogServer.this.action(DialogServer.this.user);
                }
                if (o == DialogServer.this.databases) {
                    DialogServer.this.action(DialogServer.this.dbsP);
                }
                if (o == DialogServer.this.sess) {
                    DialogServer.this.action(DialogServer.this.refreshSess);
                }
            }
        });
        KeyAdapter startListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent key) {
                if (key.getKeyCode() == 10) {
                    DialogServer.this.action(DialogServer.this.start);
                }
            }
        };
        this.ports.addKeyListener(startListener);
        KeyAdapter connListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent key) {
                if (key.getKeyCode() == 10) {
                    DialogServer.this.action(DialogServer.this.connect);
                }
            }
        };
        this.admuser.addKeyListener(connListener);
        this.admpass.addKeyListener(connListener);
        this.host.addKeyListener(connListener);
        this.portc.addKeyListener(connListener);
        this.refreshLog();
        this.action(null);
        this.setResizable(true);
        this.finish(null);
    }

    private boolean ping(boolean local) {
        GUIOptions gopts = this.gui.gopts;
        return BaseXServer.ping(local ? "localhost" : gopts.get(GUIOptions.S_HOST), gopts.get(local ? GUIOptions.S_SERVERPORT : GUIOptions.S_PORT));
    }

    @Override
    public void action(Object cmp) {
        GUIConstants.Msg icon;
        String msg;
        String msg2;
        boolean wait;
        block38: {
            boolean bl = wait = cmp == this.start || cmp == this.stop || cmp == this.connect;
            if (wait) {
                this.setCursor(GUIConstants.CURSORWAIT);
            }
            msg2 = null;
            msg = null;
            icon = GUIConstants.Msg.SUCCESS;
            try {
                if (cmp == this.start) {
                    try {
                        int p = Integer.parseInt(this.ports.getText());
                        this.gui.gopts.set(GUIOptions.S_SERVERPORT, p);
                        if (this.host.getText().equals("localhost")) {
                            this.gui.gopts.set(GUIOptions.S_PORT, p);
                            this.gui.gopts.set(GUIOptions.S_EVENTPORT, p + 1);
                            this.portc.setText(String.valueOf(p));
                        }
                        BaseXServer.start(p, "-p", Integer.toString(p), "-e", Integer.toString(p + 1));
                        msg = Util.info(Text.SRV_STARTED_PORT_X, p);
                        this.running = true;
                    }
                    catch (BaseXException ex) {
                        msg = Util.message(ex);
                        icon = GUIConstants.Msg.ERROR;
                    }
                } else if (cmp == this.stop) {
                    int p = this.gui.gopts.get(GUIOptions.S_SERVERPORT);
                    if (this.running) {
                        BaseXServer.stop(p, this.gui.gopts.get(GUIOptions.S_EVENTPORT));
                    }
                    this.running = this.ping(true);
                    boolean bl2 = this.connected = this.connected && this.ping(false);
                    if (!this.connected) {
                        msg = Util.info(Text.SRV_STOPPED_PORT_X, p);
                    }
                    if (!this.connected) {
                        this.setTitle(Text.S_SERVER_ADMIN);
                    }
                } else if (cmp == this.connect) {
                    String pw = new String(this.admpass.getPassword());
                    String us = this.admuser.getText();
                    String hs = this.host.getText();
                    int pc = Integer.parseInt(this.portc.getText());
                    this.gui.gopts.set(GUIOptions.S_HOST, hs);
                    this.gui.gopts.set(GUIOptions.S_PORT, pc);
                    this.gui.gopts.set(GUIOptions.S_USER, us);
                    this.gui.gopts.set(GUIOptions.S_PASSWORD, pw);
                    this.cs = new ClientSession(hs, pc, us, pw);
                    this.user.setSess(this.cs);
                    this.dbsP.setSess(this.cs);
                    this.connected = true;
                    this.setTitle(Text.S_SERVER_ADMIN + "- " + us + '@' + hs + ":" + pc);
                    msg = Util.info(Text.S_CONNECTED, hs, pc);
                    this.refreshSess();
                    this.disconnect.requestFocusInWindow();
                } else if (cmp == this.disconnect) {
                    this.cs.execute(new Exit());
                    this.connected = false;
                    this.setTitle(Text.S_SERVER_ADMIN);
                    msg = Text.S_DISCONNECTED;
                } else if (cmp == this.refreshSess) {
                    this.refreshSess();
                } else if (cmp == this.refreshLog || cmp == this.logc) {
                    byte[] cont = Token.EMPTY;
                    if (this.logc.getSelectedIndex() != -1) {
                        cont = new IOFile(this.logd, this.logc.getSelectedItem()).read();
                    }
                    this.logt.setText(cont);
                    this.logt.scrollToEnd();
                } else if (cmp == this.delete) {
                    IOFile f = new IOFile(this.logd, this.logc.getSelectedItem());
                    if (f.delete()) {
                        this.logc.setSelectedIndex(-1);
                        this.refreshLog();
                    } else {
                        msg2 = Util.info(Text.FILE_NOT_DELETED_X, f.name());
                        icon = GUIConstants.Msg.ERROR;
                    }
                } else if (cmp == this.deleteAll) {
                    IO file = null;
                    for (int i = 0; i < this.logc.getItemCount(); ++i) {
                        IOFile f = new IOFile(this.logd, this.logc.getItemAt(i).toString());
                        if (f.delete()) continue;
                        file = f;
                    }
                    if (file != null) {
                        msg2 = Util.info(Text.FILE_NOT_DELETED_X, file.name());
                        icon = GUIConstants.Msg.ERROR;
                    }
                    this.logc.setSelectedIndex(-1);
                    this.refreshLog();
                } else if (this.connected) {
                    if (this.tab == 1) {
                        this.user.action(cmp);
                    }
                    if (this.tab == 2) {
                        this.dbsP.action(cmp);
                    }
                }
            }
            catch (Exception ex) {
                icon = GUIConstants.Msg.ERROR;
                msg = Util.message(ex);
                if (!msg.equals(Util.info(Text.PERM_REQUIRED_X, new Object[]{Perm.ADMIN}))) break block38;
                try {
                    this.cs.execute(new Exit());
                }
                catch (IOException exx) {
                    Util.stack(exx);
                }
            }
        }
        if (wait) {
            this.setCursor(GUIConstants.CURSORARROW);
        }
        boolean valp = this.portc.getText().matches("[\\d]+") && Integer.parseInt(this.portc.getText()) <= 65535;
        boolean valpl = this.ports.getText().matches("[\\d]+") && Integer.parseInt(this.ports.getText()) <= 65535;
        boolean vallu = Databases.validName(this.admuser.getText());
        boolean vallp = new String(this.admpass.getPassword()).matches("[^ ;'\"]*");
        boolean valh = this.host.getText().matches("([\\w]+://)?[\\w.-]+");
        if (!(msg != null || msg2 != null || valpl && valh && valp && vallu && vallp)) {
            Object[] objectArray = new Object[1];
            objectArray[0] = valpl ? (valh ? (valp ? (vallu ? Text.PASSWORD : Text.USERNAME) : Text.S_PORT) : Text.S_HOST) : Text.S_LOCALPORT;
            msg = Util.info(Text.INVALID_X, objectArray);
            icon = GUIConstants.Msg.WARN;
        }
        this.infoC.setText(msg, icon);
        this.infoL.setText(msg2, icon);
        this.ports.setEnabled(!this.running);
        this.start.setEnabled(!this.running && valpl);
        this.stop.setEnabled(this.running);
        this.admuser.setEnabled(!this.connected);
        this.admpass.setEnabled(!this.connected);
        this.host.setEnabled(!this.connected);
        this.portc.setEnabled(!this.connected);
        this.connect.setEnabled(!this.connected && vallu && vallp && valh && valp && !this.admuser.getText().isEmpty() && this.admpass.getPassword().length != 0);
        this.disconnect.setEnabled(this.connected);
        this.tabs.setEnabledAt(1, this.connected);
        this.tabs.setEnabledAt(2, this.connected);
        this.tabs.setEnabledAt(3, this.connected);
        this.tabs.setEnabledAt(4, this.running || this.logc.getItemCount() > 0);
        this.refreshLog.setEnabled(this.logc.getSelectedIndex() != -1);
        this.delete.setEnabled(this.logc.getSelectedIndex() != -1);
        this.deleteAll.setEnabled(this.logc.getItemCount() > 0);
        if (this.admuser.hasFocus()) {
            this.connect.setEnabled(false);
        }
    }

    private void refreshSess() throws IOException {
        this.sese.setText(Token.token(this.cs.execute(new ShowSessions())));
    }

    private void refreshLog() {
        this.logc.removeAllItems();
        StringList sl = new StringList();
        for (IOFile s : this.logd.children()) {
            String name = s.name();
            if (!name.endsWith(".log")) continue;
            sl.add(name);
        }
        for (String s : sl.sort(false, false)) {
            this.logc.addItem(s);
        }
        this.action(this.refreshLog);
    }

    @Override
    public void cancel() {
        try {
            if (this.connected) {
                this.cs.execute(new Exit());
            }
        }
        catch (IOException ex) {
            Util.debug(ex);
        }
        super.cancel();
    }

    @Override
    public void close() {
        if (this.ok) {
            super.close();
        }
    }
}

