/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.util.Locale;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXDialog;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.util.Util;

public final class BaseXFileChooser {
    private GUI gui;
    private JFileChooser fc;
    private FileDialog fd;
    private String suffix;

    public BaseXFileChooser(String title, String path, GUI main) {
        if (main.gopts.get(GUIOptions.SIMPLEFD).booleanValue()) {
            this.fd = new FileDialog((Frame)main, title);
            this.fd.setDirectory(new File(path).getPath());
        } else {
            this.fc = new JFileChooser(path);
            File file = new File(path);
            if (!file.isDirectory()) {
                this.fc.setSelectedFile(file);
            }
            this.fc.setDialogTitle(title);
            this.gui = main;
        }
    }

    public BaseXFileChooser textFilters() {
        this.filter("XML Documents", IO.XMLSUFFIXES);
        this.filter("XSL Documents", IO.XSLSUFFIXES);
        this.filter("HTML Documents", IO.HTMLSUFFIXES);
        this.filter("JSON Documents", ".json");
        this.filter("Comma-Separated Values", ".csv");
        this.filter("Plain Text", IO.TXTSUFFIXES);
        return this;
    }

    public BaseXFileChooser filter(String dsc, String ... suf) {
        if (this.fc != null) {
            FileFilter ff = this.fc.getFileFilter();
            this.fc.addChoosableFileFilter(new Filter(suf, dsc));
            this.fc.setFileFilter(ff);
        }
        return this;
    }

    public BaseXFileChooser suffix(String suf) {
        this.suffix = suf;
        return this;
    }

    public BaseXFileChooser multi() {
        if (this.fc != null) {
            this.fc.setMultiSelectionEnabled(true);
        }
        return this;
    }

    public IOFile select(Mode mode) {
        IOFile[] files = this.selectAll(mode);
        return files.length == 0 ? null : files[0];
    }

    public IOFile[] selectAll(Mode mode) {
        File[] fileArray;
        if (this.fd != null) {
            if (mode == Mode.FDOPEN) {
                this.fd.setFile(" ");
            }
            this.fd.setMode(mode == Mode.FSAVE || mode == Mode.DSAVE ? 1 : 0);
            this.fd.setVisible(true);
            String f = this.fd.getFile();
            if (f == null) {
                return new IOFile[0];
            }
            String dir = this.fd.getDirectory();
            return new IOFile[]{new IOFile(mode == Mode.DOPEN || mode == Mode.DSAVE ? dir : dir + '/' + this.fd.getFile())};
        }
        int state = 0;
        switch (mode) {
            case FOPEN: {
                state = this.fc.showOpenDialog(this.gui);
                break;
            }
            case FDOPEN: {
                this.fc.setFileSelectionMode(2);
                state = this.fc.showOpenDialog(this.gui);
                break;
            }
            case FSAVE: {
                state = this.fc.showSaveDialog(this.gui);
                break;
            }
            case DOPEN: 
            case DSAVE: {
                this.fc.setFileSelectionMode(1);
                state = this.fc.showDialog(this.gui, null);
            }
        }
        if (state != 0) {
            return new IOFile[0];
        }
        if (this.fc.isMultiSelectionEnabled()) {
            fileArray = this.fc.getSelectedFiles();
        } else {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = this.fc.getSelectedFile();
        }
        File[] fl = fileArray;
        IOFile[] files = new IOFile[fl.length];
        for (int f = 0; f < fl.length; ++f) {
            files[f] = new IOFile(fl[f].getPath());
        }
        if (mode == Mode.FSAVE) {
            FileFilter ff = this.fc.getFileFilter();
            if (this.suffix != null) {
                for (int f = 0; f < files.length; ++f) {
                    String path = files[f].path();
                    if (path.contains(".")) continue;
                    files[f] = new IOFile(path + this.suffix);
                }
            } else if (ff instanceof Filter) {
                String[] sufs = ((Filter)ff).sufs;
                for (int f = 0; f < files.length && sufs.length != 0; ++f) {
                    String path = files[f].path();
                    if (path.contains(".")) continue;
                    files[f] = new IOFile(path + sufs[0]);
                }
            }
            for (IOFile io : files) {
                if (!io.exists() || BaseXDialog.confirm(this.gui, Util.info(Text.FILE_EXISTS_X, io))) continue;
                return new IOFile[0];
            }
        }
        return files;
    }

    private static class Filter
    extends FileFilter {
        final String[] sufs;
        final String desc;

        Filter(String[] s, String d) {
            this.sufs = s;
            this.desc = d;
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String name = file.getName().toLowerCase(Locale.ENGLISH);
            for (String s : this.sufs) {
                if (!name.endsWith(s)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String getDescription() {
            StringBuilder sb = new StringBuilder();
            for (String s : this.sufs) {
                if (sb.length() != 0) {
                    sb.append(", ");
                }
                sb.append('*').append(s);
            }
            return this.desc + " (" + sb + ')';
        }
    }

    public static enum Mode {
        FOPEN,
        FDOPEN,
        DOPEN,
        FSAVE,
        DSAVE;

    }
}

