/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.basex.gui.GUI;
import org.basex.gui.GUICommand;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIMenuCmd;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.text.SearchBar;
import org.basex.gui.text.TextPanel;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.Util;

public final class BaseXLayout {
    private static final Map<?, ?> HINTS = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
    private static boolean hints = true;
    private static final String META = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() == 4 ? "meta" : "ctrl";
    private static KeyAdapter keys;

    private BaseXLayout() {
    }

    static void focus(Component cont) {
        GUI gui = BaseXLayout.gui(cont);
        if (gui == null) {
            return;
        }
        if (gui.gopts.get(GUIOptions.MOUSEFOCUS).booleanValue() && cont.isEnabled()) {
            cont.requestFocusInWindow();
        }
    }

    public static void hints(Graphics g) {
        if (hints) {
            try {
                ((Graphics2D)g).addRenderingHints(HINTS);
            }
            catch (Exception ex) {
                Util.debug(ex);
                hints = false;
            }
        }
    }

    private static GUI gui(Component cont) {
        Container c = cont.getParent();
        return c == null || c instanceof GUI ? (GUI)c : BaseXLayout.gui(c);
    }

    public static void setWidth(Component comp, int w) {
        comp.setPreferredSize(new Dimension(w, comp.getPreferredSize().height));
    }

    public static void setHeight(Component comp, int h) {
        comp.setPreferredSize(new Dimension(comp.getPreferredSize().width, h));
    }

    static void setSize(Component comp, int w, int h) {
        comp.setPreferredSize(new Dimension(w, h));
    }

    public static void addDrop(final JComponent comp, final DropHandler dnd) {
        comp.setDropTarget(new DropTarget(comp, 3, null, true, null){

            @Override
            public synchronized void drop(DropTargetDropEvent dtde) {
                dtde.acceptDrop(3);
                Transferable tr = dtde.getTransferable();
                for (Object o : BaseXLayout.contents(tr)) {
                    dnd.drop(o);
                }
                comp.requestFocusInWindow();
            }
        });
    }

    public static KeyStroke keyStroke(GUICommand cmd) {
        String scut;
        Object sc = cmd.shortcuts();
        if (sc == null) {
            return null;
        }
        if (sc instanceof BaseXKeys[]) {
            BaseXKeys[] scs = (BaseXKeys[])sc;
            if (scs.length == 0) {
                return null;
            }
            scut = scs[0].shortCut();
        } else {
            scut = Util.info(sc, META);
        }
        KeyStroke ks = KeyStroke.getKeyStroke(scut);
        if (ks == null) {
            Util.errln("Could not assign shortcut: " + sc + " / " + scut, new Object[0]);
        }
        return ks;
    }

    public static void setMnemonic(AbstractButton b, StringBuilder mnem) {
        if (Prop.MAC) {
            return;
        }
        String label = b.getText();
        for (int l = 0; l < label.length(); ++l) {
            char ch = Character.toLowerCase(label.charAt(l));
            if (!Token.letter(ch) || mnem.indexOf(Character.toString(ch)) != -1) continue;
            b.setMnemonic(ch);
            mnem.append(ch);
            break;
        }
    }

    public static ArrayList<Object> contents(Transferable tr) {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                for (File fl : (List)tr.getTransferData(DataFlavor.javaFileListFlavor)) {
                    list.add(fl);
                }
            } else if (tr.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                list.add(tr.getTransferData(DataFlavor.stringFlavor));
            }
        }
        catch (Exception ex) {
            Util.stack(ex);
        }
        return list;
    }

    public static void copy(String text) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(text), null);
    }

    public static void addInteraction(final Component comp, Window win) {
        comp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                BaseXLayout.focus(comp);
            }
        });
        if (win instanceof BaseXDialog) {
            final BaseXDialog d = (BaseXDialog)win;
            comp.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    Object s = e.getSource();
                    if (s instanceof BaseXCombo && ((JComboBox)s).isPopupVisible()) {
                        return;
                    }
                    if (BaseXKeys.ENTER.is(e) && !(s instanceof BaseXButton) && !(s instanceof TextPanel)) {
                        d.close();
                    } else if (BaseXKeys.ESCAPE.is(e)) {
                        boolean close = true;
                        if (s instanceof TextPanel) {
                            SearchBar bar = ((TextPanel)s).getSearch();
                            boolean bl = close = bar == null || !bar.deactivate(true);
                        }
                        if (close) {
                            d.cancel();
                        }
                    }
                }
            });
            return;
        }
        if (!(win instanceof GUI)) {
            throw Util.notExpected("Reference to main window expected.");
        }
        comp.addKeyListener(BaseXLayout.globalShortcuts((GUI)win));
    }

    private static KeyAdapter globalShortcuts(final GUI gui) {
        if (keys == null) {
            keys = new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    int fs;
                    if (gui.context.data() != null) {
                        if (BaseXKeys.GOBACK.is(e)) {
                            GUIMenuCmd.C_GOBACK.execute(gui);
                        } else if (BaseXKeys.GOFORWARD.is(e)) {
                            GUIMenuCmd.C_GOFORWARD.execute(gui);
                        } else if (BaseXKeys.GOUP.is(e)) {
                            GUIMenuCmd.C_GOUP.execute(gui);
                        } else if (BaseXKeys.GOHOME.is(e)) {
                            GUIMenuCmd.C_GOHOME.execute(gui);
                        }
                    }
                    if (BaseXKeys.INPUTBAR.is(e)) {
                        gui.input.requestFocusInWindow();
                    }
                    int nfs = fs = gui.gopts.get(GUIOptions.FONTSIZE).intValue();
                    if (BaseXKeys.INCFONT1.is(e) || BaseXKeys.INCFONT2.is(e)) {
                        nfs = fs + 1;
                    } else if (BaseXKeys.DECFONT.is(e)) {
                        nfs = Math.max(1, fs - 1);
                    } else if (BaseXKeys.NORMFONT.is(e)) {
                        nfs = 13;
                    }
                    if (fs != nfs) {
                        gui.gopts.set(GUIOptions.FONTSIZE, nfs);
                        gui.updateLayout();
                    }
                }
            };
        }
        return keys;
    }

    public static String addShortcut(String str, String sc) {
        if (sc == null || str == null) {
            return str;
        }
        StringBuilder sb = new StringBuilder();
        for (String s : sc.split(" ")) {
            String t;
            String string = "%".equals(s) ? (Prop.MAC ? "meta" : "control") : (t = s);
            if (t.length() != 1) {
                t = Toolkit.getProperty("AWT." + t.toLowerCase(), t);
            }
            sb.append('+').append(t);
        }
        return str + " (" + sb.substring(1) + ')';
    }

    public static String value(double val) {
        return Token.string(Token.chopNumber(Token.token(val)));
    }

    public static void fill(Graphics gg, Color c1, Color c2, int xs, int ys, int xe, int ye) {
        int w = xe - xs;
        int h = ye - ys;
        int r = c1.getRed();
        int g = c1.getGreen();
        int b = c1.getBlue();
        float rf = (float)(c2.getRed() - r) / (float)h;
        float gf = (float)(c2.getGreen() - g) / (float)h;
        float bf = (float)(c2.getBlue() - b) / (float)h;
        int hh = 0;
        int cr = 0;
        int cg = 0;
        int cb = 0;
        for (int y = 0; y < h; ++y) {
            int nr = r + (int)(rf * (float)y);
            int ng = g + (int)(gf * (float)y);
            int nb = b + (int)(bf * (float)y);
            if (nr != cr || ng != cg || nb != cb) {
                gg.setColor(new Color(nr, ng, nb));
                gg.fillRect(xs, ys + y - hh, w, hh);
                hh = 0;
            }
            cr = nr;
            cg = ng;
            cb = nb;
            ++hh;
        }
        gg.fillRect(xs, ys + h - hh, w, hh);
    }

    public static void drawCell(Graphics g, int xs, int xe, int ys, int ye, boolean focus) {
        g.setColor(GUIConstants.GRAY);
        g.drawRect(xs, ys, xe - xs - 1, ye - ys - 1);
        g.setColor(Color.white);
        g.drawRect(xs + 1, ys + 1, xe - xs - 3, ye - ys - 3);
        BaseXLayout.fill(g, focus ? GUIConstants.LGRAY : Color.white, GUIConstants.LGRAY, xs + 2, ys + 2, xe - 1, ye - 1);
    }

    public static void drawCenter(Graphics g, String text, int w, int y) {
        g.drawString(text, (w - BaseXLayout.width(g, text)) / 2, y);
    }

    public static void drawTooltip(Graphics g, String tt, int x, int y, int w, int c) {
        int tw = BaseXLayout.width(g, tt);
        int th = g.getFontMetrics().getHeight();
        int xx = Math.min(w - tw - 8, x);
        g.setColor(GUIConstants.color(c));
        g.fillRect(xx - 1, y - th, tw + 4, th);
        g.setColor(Color.white);
        g.drawString(tt, xx, y - 4);
    }

    public static int width(Graphics g, String s) {
        return g.getFontMetrics().stringWidth(s);
    }

    public static void chopString(Graphics g, byte[] s, int x, int y, int w, int fs) {
        if (w < 12) {
            return;
        }
        int[] cw = GUIConstants.fontWidths(g.getFont());
        int j = s.length;
        try {
            int l = 0;
            int fw = 0;
            for (int k = 0; k < j; k += l) {
                int ww = BaseXLayout.width(g, cw, Token.cp(s, k));
                if (fw + ww >= w - 4) {
                    j = Math.max(1, k - l);
                    if (k > 1) {
                        fw -= BaseXLayout.width(g, cw, Token.cp(s, k - 1));
                    }
                    g.drawString("..", x + fw, y + fs);
                    break;
                }
                fw += ww;
                l = Token.cl(s, k);
            }
        }
        catch (Exception ex) {
            Util.debug(ex);
        }
        g.drawString(Token.string(s, 0, j), x, y + fs);
    }

    public static int width(Graphics g, byte[] s) {
        int[] cw = GUIConstants.fontWidths(g.getFont());
        int l = s.length;
        int fw = 0;
        try {
            for (int k = 0; k < l; k += Token.cl(s, k)) {
                fw += BaseXLayout.width(g, cw, Token.cp(s, k));
            }
        }
        catch (Exception ex) {
            Util.debug(ex);
        }
        return fw;
    }

    public static int width(Graphics g, int[] cw, int c) {
        return c >= cw.length ? g.getFontMetrics().charWidth(c) : cw[c];
    }

    public static interface DropHandler {
        public void drop(Object var1);
    }
}

