/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import org.basex.core.Text;
import org.basex.gui.AGUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIPopupCmd;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXPanel;
import org.basex.gui.layout.BaseXPopup;
import org.basex.gui.view.ViewContainer;
import org.basex.gui.view.ViewPanel;

final class ViewMover
extends BaseXPanel {
    private int height;
    private boolean active;
    private boolean in;

    ViewMover(AGUI main) {
        super(main);
        this.setLayout(new BorderLayout());
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setCursor(GUIConstants.CURSORMOVE);
        this.refreshLayout();
        new BaseXPopup(this, new GUIPopupCmd(Text.CLOSE, new BaseXKeys[0]){

            @Override
            public void execute() {
                ((ViewPanel)ViewMover.this.getParent()).delete();
            }
        });
    }

    @Override
    public void paintComponent(Graphics g) {
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int w = this.getWidth();
        int h = this.getHeight();
        g.setColor(GUIConstants.color(this.active ? 5 : (this.in ? 3 : 1)));
        g.fillRect(0, 0, w, h);
        g.setColor(GUIConstants.color(this.active ? 16 : (this.in ? 13 : 10)));
        int d = this.height >> 1;
        for (int x = -d >> 1; x < w; x += 2 + (this.height >> 2)) {
            g.drawLine(x + d, 0, x, h - 1);
        }
        g.drawRect(0, 0, w - 1, h - 1);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        ViewPanel view = (ViewPanel)this.getParent();
        Container comp = view;
        while (!((comp = comp.getParent()) instanceof ViewContainer)) {
        }
        Point a = this.getLocationOnScreen();
        Point b = comp.getLocationOnScreen();
        Point c = new Point(a.x - b.x + e.getX(), a.y - b.y + e.getY());
        ((ViewContainer)comp).dragPanel(view, c);
        this.active = true;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.active = true;
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.active) {
            return;
        }
        Container comp = this;
        while (!((comp = comp.getParent()) instanceof ViewContainer)) {
        }
        ((ViewContainer)comp).dropPanel();
        this.active = false;
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.in = true;
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.in = false;
        this.repaint();
    }

    public void refreshLayout() {
        this.height = Math.max(10, 6 + (int)((double)GUIConstants.fontSize * 0.333));
        BaseXLayout.setHeight(this, this.height);
    }
}

