/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.info;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import org.basex.core.Command;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.core.cmd.AQuery;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.TableLayout;
import org.basex.gui.text.LinkListener;
import org.basex.gui.text.SearchEditor;
import org.basex.gui.text.TextPanel;
import org.basex.gui.view.View;
import org.basex.gui.view.ViewNotifier;
import org.basex.util.Performance;
import org.basex.util.TokenBuilder;
import org.basex.util.list.IntList;
import org.basex.util.list.StringList;

public final class InfoView
extends View
implements LinkListener {
    private final SearchEditor editor;
    private final TokenBuilder text = new TokenBuilder();
    private final BaseXLabel label;
    private final BaseXLabel timer;
    private final TextPanel area;
    private IntList stat = new IntList(4);
    private StringList strings = new StringList(4);
    private boolean changed;
    private boolean clear;
    private int focus = -1;
    private int w;
    private int h;
    private int bw;
    private int bs;

    public InfoView(ViewNotifier man) {
        super("info", man);
        this.border(5).layout(new BorderLayout(0, 5));
        this.label = new BaseXLabel(Text.QUERY_INFO);
        this.label.setForeground(GUIConstants.GRAY);
        this.timer = new BaseXLabel(" ", true, false);
        this.timer.setForeground(GUIConstants.DGRAY);
        this.area = new TextPanel(false, this.gui);
        this.area.setLinkListener(this);
        this.editor = new SearchEditor(this.gui, this.area);
        AbstractButton find = this.editor.button(Text.FIND);
        BaseXBack buttons = new BaseXBack(GUIConstants.Fill.NONE);
        buttons.layout(new TableLayout(1, 3, 8, 0)).border(0, 0, 4, 0);
        buttons.add(find);
        buttons.add(this.timer);
        BaseXBack b = new BaseXBack(GUIConstants.Fill.NONE).layout(new BorderLayout());
        b.add((Component)buttons, "West");
        b.add((Component)this.label, "East");
        this.add((Component)b, "North");
        BaseXBack center = new BaseXBack(GUIConstants.Fill.NONE).layout(new BorderLayout());
        this.add((Component)this.editor, "Center");
        center.add((Component)this.area, "Center");
        center.add((Component)this.editor, "South");
        this.add((Component)center, "Center");
        this.refreshLayout();
    }

    @Override
    public void refreshInit() {
    }

    @Override
    public void refreshFocus() {
    }

    @Override
    public void refreshMark() {
    }

    @Override
    public void refreshContext(boolean more, boolean quick) {
    }

    @Override
    public void refreshUpdate() {
    }

    @Override
    public void refreshLayout() {
        this.label.border(-6, 0, 0, 2).setFont(GUIConstants.lfont);
        this.timer.setFont(GUIConstants.font);
        this.area.setFont(GUIConstants.font);
        this.editor.bar().refreshLayout();
    }

    @Override
    public boolean visible() {
        return this.gui.gopts.get(GUIOptions.SHOWINFO);
    }

    @Override
    public void visible(boolean v) {
        this.gui.gopts.set(GUIOptions.SHOWINFO, v);
    }

    @Override
    protected boolean db() {
        return false;
    }

    public void setInfo(String info, Command cmd, boolean ok, boolean reset) {
        this.setInfo(info, cmd, null, ok, reset);
    }

    public void setInfo(String info, Command cmd, String time, boolean ok, boolean reset) {
        StringList eval = new StringList(1);
        StringList comp = new StringList(1);
        StringList plan = new StringList(1);
        StringList result = new StringList(1);
        StringList stack = new StringList(1);
        StringList err = new StringList(1);
        StringList origqu = new StringList(1);
        StringList optqu = new StringList(1);
        StringList command = new StringList(1);
        StringList timings = new StringList(5);
        IntList times = new IntList(5);
        int runs = Math.max(1, this.gui.context.options.get(MainOptions.RUNS));
        String[] split = info.split(Text.NL);
        block0: for (int i = 0; i < split.length; ++i) {
            String line = split[i];
            if (line.startsWith(Text.PARSING_CC) || line.startsWith(Text.COMPILING_CC) || line.startsWith(Text.EVALUATING_CC) || line.startsWith(Text.PRINTING_CC) || line.startsWith(Text.TOTAL_TIME_CC)) {
                int t = line.indexOf(" ms");
                int s = line.indexOf(58);
                int tm = (int)(Double.parseDouble(line.substring(s + 1, t)) * 100.0);
                times.add(tm);
                String key = line.substring(0, s).trim();
                String val = Performance.getTime((long)tm * 10000L * (long)runs, runs);
                timings.add("- " + key + ": " + val);
                continue;
            }
            if (line.startsWith(Text.HITS_X_CC) || line.startsWith(Text.UPDATED_CC) || line.startsWith(Text.PRINTED_CC) || line.startsWith(Text.READ_LOCKING_CC) || line.startsWith(Text.WRITE_LOCKING_CC)) {
                result.add("- " + line);
                continue;
            }
            if (line.equals(Text.COMPILING + ":")) {
                while (++i < split.length && !split[i].isEmpty()) {
                    comp.add(split[i]);
                }
                continue;
            }
            if (line.equals(Text.QUERY + ":")) {
                while (++i < split.length && !split[i].isEmpty()) {
                    origqu.add(split[i]);
                }
                continue;
            }
            if (line.equals(Text.OPTIMIZED_QUERY + ":")) {
                while (++i < split.length && !split[i].isEmpty()) {
                    optqu.add(split[i]);
                }
                continue;
            }
            if (line.startsWith(Text.EVALUATING)) {
                while (++i < split.length && split[i].startsWith("- ")) {
                    eval.add(split[i]);
                }
                continue;
            }
            if (line.equals(Text.QUERY_PLAN + ":")) {
                while (++i < split.length && !split[i].isEmpty()) {
                    plan.add(split[i]);
                }
                continue;
            }
            if (line.equals(Text.ERROR + ":")) {
                while (++i < split.length && !split[i].isEmpty()) {
                    Pattern p = Pattern.compile(Text.STOPPED_AT + "(.*)" + ":");
                    Matcher m = p.matcher(split[i]);
                    if (m.find()) {
                        TokenBuilder tb = new TokenBuilder();
                        tb.add(Text.STOPPED_AT).uline().add(m.group(1)).uline().add(":");
                        split[i] = tb.toString();
                    }
                    err.add(split[i]);
                }
                continue;
            }
            if (line.equals("Stack Trace:")) {
                while (++i < split.length && !split[i].isEmpty()) {
                    boolean last;
                    TokenBuilder tb = new TokenBuilder();
                    String sp = split[i].replaceAll("<.*", "");
                    boolean bl = last = !sp.equals(split[i]);
                    if (sp.startsWith("- ")) {
                        tb.add("- ").uline().add(sp.substring(2)).uline();
                    } else {
                        tb.add(sp);
                    }
                    stack.add(tb.toString());
                    if (!last) continue;
                    continue block0;
                }
                continue;
            }
            if (ok || line.isEmpty()) continue;
            err.add(line);
        }
        this.stat = times;
        this.strings = timings;
        if (this.clear || !times.isEmpty() || !ok) {
            this.text.reset();
        }
        String inf = null;
        if (!(cmd instanceof AQuery)) {
            if (cmd != null) {
                command.add(cmd.toString());
            }
            if (ok && !info.isEmpty()) {
                if (reset) {
                    result.add(info.trim());
                } else if (cmd == null) {
                    inf = info.trim();
                }
            }
        }
        this.add(Text.COMMAND + ":", command);
        this.add(Text.ERROR + ":", err);
        this.add("Stack Trace:", stack);
        this.add(Text.EVALUATING + ":", eval);
        this.add(Text.COMPILING + ":", comp);
        this.add(Text.QUERY + ":", origqu);
        this.add(Text.OPTIMIZED_QUERY + ":", optqu);
        this.add(Text.RESULT + ":", result);
        this.add(Text.TIMING + ":", timings);
        this.add(Text.QUERY_PLAN + ":", plan);
        if (inf != null) {
            this.text.add(inf).nline();
        }
        this.changed = true;
        this.clear = reset;
        String total = time;
        if (!times.isEmpty()) {
            total = Performance.getTime((long)times.get(times.size() - 1) * 10000L * (long)runs, runs);
        }
        if (total != null) {
            this.timer.setText(Text.TOTAL_TIME_CC + total);
        }
        this.repaint();
    }

    private void add(String head, StringList list) {
        if (list.isEmpty()) {
            return;
        }
        this.text.bold().add(head).norm().nline();
        for (String s : list) {
            this.text.add(s).nline();
        }
        this.text.hline();
    }

    @Override
    public void linkClicked(String link) {
        this.gui.editor.jump(link);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int l = this.stat.size();
        if (l == 0) {
            return;
        }
        this.focus = -1;
        if (e.getY() < this.h) {
            for (int i = 0; i < l; ++i) {
                int bx = this.w - this.bw + this.bs * i;
                if (e.getX() < bx || e.getX() >= bx + this.bs) continue;
                this.focus = i;
            }
        }
        int f = this.focus == -1 ? l - 1 : this.focus;
        this.timer.setText(this.strings.get(f).replace("- ", ""));
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        int bx;
        int i;
        if (this.changed) {
            this.area.setText(this.text.finish());
            this.changed = false;
        }
        super.paintComponent(g);
        int l = this.stat.size();
        if (l == 0) {
            return;
        }
        int fs = GUIConstants.fontSize;
        this.h = this.label.getHeight() + 4;
        this.w = (int)((double)this.getWidth() * 0.98 - (double)(fs / 2) - (double)this.label.getWidth());
        this.bw = fs * 2 + this.w / 10;
        this.bs = this.bw / (l - 1);
        int m = 1;
        for (int i2 = 0; i2 < l - 1; ++i2) {
            m = Math.max(m, this.stat.get(i2));
        }
        int by = 8;
        int bh = this.h - 8;
        for (i = 0; i < l - 1; ++i) {
            if (i != this.focus) continue;
            bx = this.w - this.bw + this.bs * i;
            g.setColor(GUIConstants.color3);
            g.fillRect(bx, 8, this.bs + 1, bh);
        }
        for (i = 0; i < l - 1; ++i) {
            bx = this.w - this.bw + this.bs * i;
            g.setColor(GUIConstants.color((i == this.focus ? 3 : 2) + i * 2));
            int p = Math.max(1, this.stat.get(i) * bh / m);
            g.fillRect(bx, 8 + bh - p, this.bs, p);
            g.setColor(GUIConstants.color(8));
            g.drawRect(bx, 8 + bh - p, this.bs, p - 1);
        }
    }
}

