/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.map;

import java.awt.Color;
import java.awt.Graphics;
import org.basex.data.Data;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.view.ViewData;
import org.basex.gui.view.map.MapPainter;
import org.basex.gui.view.map.MapRect;
import org.basex.gui.view.map.MapRects;
import org.basex.gui.view.map.MapRenderer;
import org.basex.gui.view.map.MapView;

final class MapDefault
extends MapPainter {
    MapDefault(MapView m, GUIOptions opts) {
        super(m, opts);
    }

    @Override
    void drawRectangles(Graphics g, MapRects rects, float scale) {
        MapRect l = this.view.layout.layout;
        l.x = (int)scale * l.x;
        l.y = (int)scale * l.y;
        l.w = (int)scale * l.w;
        l.h = (int)scale * l.h;
        int ww = this.view.getWidth();
        int hh = this.view.getWidth();
        Data data = this.view.gui.context.data();
        int fsz = GUIConstants.fontSize;
        int off = this.gopts.get(GUIOptions.MAPOFFSETS);
        int rs = rects.size;
        for (int ri = 0; ri < rs; ++ri) {
            MapRect r = rects.get(ri);
            int pre = r.pre;
            int lvl = r.level;
            boolean full = r.w == ww && r.h == hh;
            Color col = this.color(rects, ri);
            boolean mark = col != null;
            r.pos = this.view.gui.context.marked.ftpos != null ? this.view.gui.context.marked.ftpos.get(data, pre) : null;
            g.setColor(mark ? col : GUIConstants.color(lvl));
            if (r.w < l.x + l.w || r.h < l.y + l.h || off < 2 || ViewData.leaf(this.gopts, data, pre)) {
                g.fillRect(r.x, r.y, r.w, r.h);
            } else {
                g.fillRect(r.x, r.y, l.x, r.h);
                g.fillRect(r.x, r.y, r.w, l.y);
                g.fillRect(r.x + r.w - l.w, r.y, l.w, r.h);
                g.fillRect(r.x, r.y + r.h - l.h, r.w, l.h);
            }
            if (!full) {
                col = mark ? GUIConstants.colormark3 : GUIConstants.color(lvl + 2);
                g.setColor(col);
                g.drawRect(r.x, r.y, r.w, r.h);
                col = mark ? GUIConstants.colormark4 : GUIConstants.color(Math.max(0, lvl - 2));
                g.setColor(col);
                g.drawLine(r.x + r.w, r.y, r.x + r.w, r.y + r.h);
                g.drawLine(r.x, r.y + r.h, r.x + r.w, r.y + r.h);
            }
            if (r.w <= 3 || r.h < GUIConstants.fontSize) continue;
            r.x += 3;
            r.w -= 3;
            int kind = data.kind(pre);
            if (kind == 1 || kind == 0) {
                g.setColor(Color.black);
                g.setFont(GUIConstants.font);
                BaseXLayout.chopString(g, ViewData.name(this.gopts, data, pre), r.x, r.y, r.w, fsz);
            } else {
                g.setColor(GUIConstants.color(r.level * 2 + 8));
                g.setFont(GUIConstants.mfont);
                byte[] text = ViewData.content(data, pre, false);
                boolean bl = r.thumb = MapRenderer.calcHeight(g, r, text, fsz) >= r.h;
                if (r.thumb) {
                    MapRenderer.drawThumbnails(g, r, text, fsz);
                } else {
                    MapRenderer.drawText(g, r, text, fsz);
                }
            }
            r.x -= 3;
            r.w += 3;
        }
    }
}

