/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.text;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.AbstractButton;
import org.basex.core.Command;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.core.parse.CommandParser;
import org.basex.data.Nodes;
import org.basex.data.Result;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIMenuCmd;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXFileChooser;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.TableLayout;
import org.basex.gui.text.SearchEditor;
import org.basex.gui.text.SyntaxXML;
import org.basex.gui.text.TextPanel;
import org.basex.gui.view.View;
import org.basex.gui.view.ViewNotifier;
import org.basex.io.IOFile;
import org.basex.io.out.ArrayOutput;
import org.basex.io.out.PrintOutput;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryException;
import org.basex.util.Token;
import org.basex.util.Util;

public final class TextView
extends View {
    private final SearchEditor search;
    private final BaseXLabel label;
    private final AbstractButton home;
    private final TextPanel text;
    private Command cmd;
    private Nodes ns;

    public TextView(ViewNotifier man) {
        super("text", man);
        this.border(5).layout(new BorderLayout(0, 5));
        this.label = new BaseXLabel(Text.RESULT, true, false);
        this.label.setForeground(GUIConstants.GRAY);
        this.home = BaseXButton.command(GUIMenuCmd.C_HOME, this.gui);
        this.home.setEnabled(false);
        this.text = new TextPanel(false, this.gui);
        this.text.setSyntax(new SyntaxXML());
        this.search = new SearchEditor(this.gui, this.text);
        AbstractButton save = BaseXButton.get("c_save", Text.SAVE, false, this.gui);
        AbstractButton find = this.search.button(Text.FIND);
        BaseXBack buttons = new BaseXBack(GUIConstants.Fill.NONE);
        buttons.layout(new TableLayout(1, 3, 1, 0)).border(0, 0, 4, 0);
        buttons.add(save);
        buttons.add(this.home);
        buttons.add(find);
        BaseXBack b = new BaseXBack(GUIConstants.Fill.NONE).layout(new BorderLayout());
        b.add((Component)buttons, "West");
        b.add((Component)this.label, "East");
        this.add((Component)b, "North");
        this.add((Component)this.search, "Center");
        save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextView.this.save();
            }
        });
        this.refreshLayout();
    }

    @Override
    public void refreshInit() {
        this.refreshContext(true, true);
    }

    @Override
    public void refreshFocus() {
    }

    @Override
    public void refreshMark() {
        this.setText(this.gui.context.marked);
    }

    @Override
    public void refreshContext(boolean more, boolean quick) {
        this.setText(this.gui.context.current());
    }

    @Override
    public void refreshLayout() {
        this.label.border(-6, 0, 0, 2).setFont(GUIConstants.lfont);
        this.text.setFont(GUIConstants.mfont);
        this.search.bar().refreshLayout();
    }

    @Override
    public void refreshUpdate() {
        this.refreshContext(true, true);
    }

    @Override
    public boolean visible() {
        return this.gui.gopts.get(GUIOptions.SHOWTEXT);
    }

    @Override
    public void visible(boolean v) {
        this.gui.gopts.set(GUIOptions.SHOWTEXT, v);
    }

    @Override
    protected boolean db() {
        return false;
    }

    private void setText(Nodes n) {
        if (this.visible()) {
            try {
                ArrayOutput ao = new ArrayOutput();
                ao.setLimit(this.gui.gopts.get(GUIOptions.MAXTEXT));
                if (n != null) {
                    n.serialize(Serializer.get(ao));
                }
                this.setText(ao);
                this.cmd = null;
                this.ns = ao.finished() ? n : null;
            }
            catch (IOException ex) {
                Util.debug(ex);
            }
        } else {
            this.home.setEnabled(this.gui.context.data() != null);
        }
    }

    public void cacheText(ArrayOutput out, Command c, Result r) throws QueryException {
        this.cmd = null;
        this.ns = null;
        int mh = this.gui.context.options.get(MainOptions.MAXHITS);
        boolean parse = false;
        if (mh >= 0 && r != null && r.size() >= (long)mh) {
            parse = true;
        } else if (out.finished()) {
            if (r instanceof Nodes) {
                this.ns = (Nodes)r;
            } else {
                parse = true;
            }
        }
        if (parse) {
            this.cmd = new CommandParser(c.toString(), this.gui.context).parseSingle();
        }
    }

    public void setText(ArrayOutput out) {
        byte[] buf = out.buffer();
        int size = (int)out.size();
        byte[] chop = Token.token("...");
        if (out.finished() && size >= chop.length) {
            System.arraycopy(chop, 0, buf, size - chop.length, chop.length);
        }
        this.text.setText(buf, size);
        this.label.setText((out.finished() ? Text.CHOPPED : "") + Text.RESULT);
        this.home.setEnabled(this.gui.context.data() != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() {
        BaseXFileChooser fc = new BaseXFileChooser(Text.SAVE_AS, this.gui.gopts.get(GUIOptions.WORKPATH), this.gui).suffix(".xml");
        IOFile file = fc.select(BaseXFileChooser.Mode.FSAVE);
        if (file == null) {
            return;
        }
        this.gui.gopts.set(GUIOptions.WORKPATH, file.path());
        this.gui.cursor(GUIConstants.CURSORWAIT, true);
        MainOptions opts = this.gui.context.options;
        int mh = opts.get(MainOptions.MAXHITS);
        opts.set(MainOptions.MAXHITS, -1);
        opts.set(MainOptions.CACHEQUERY, false);
        PrintOutput out = null;
        try {
            out = new PrintOutput(file.toString());
            if (this.cmd != null) {
                this.cmd.execute(this.gui.context, out);
            } else if (this.ns != null) {
                this.ns.serialize(Serializer.get(out));
            } else {
                byte[] txt;
                for (byte t : txt = this.text.getText()) {
                    if (t >= 0 && t <= 32 && !Token.ws(t)) continue;
                    out.write(t);
                }
            }
        }
        catch (IOException ex) {
            BaseXDialog.error(this.gui, Util.info(Text.FILE_NOT_SAVED_X, file));
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ignored) {}
            }
            opts.set(MainOptions.MAXHITS, mh);
            opts.set(MainOptions.CACHEQUERY, true);
            this.gui.cursor(GUIConstants.CURSORARROW, true);
        }
    }
}

