/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.path;

import java.io.IOException;
import java.util.ArrayList;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.index.Index;
import org.basex.index.path.PathNode;
import org.basex.index.query.EntryIterator;
import org.basex.index.query.IndexEntries;
import org.basex.index.query.IndexIterator;
import org.basex.index.query.IndexToken;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.util.Array;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.TokenList;

public final class PathSummary
implements Index {
    private final ArrayList<PathNode> stack = new ArrayList();
    private Data data;
    private PathNode root;

    public PathSummary() {
        this.init();
    }

    public PathSummary(Data d) {
        this();
        this.data = d;
    }

    public PathSummary(Data d, DataInput in) throws IOException {
        this.root = in.readBool() ? new PathNode(in, null) : new PathNode();
        this.data = d;
    }

    public void write(DataOutput out) throws IOException {
        out.writeBool(this.root != null);
        if (this.root != null) {
            this.root.write(out);
        }
    }

    public void data(Data d) {
        this.data = d;
    }

    @Override
    public void init() {
        this.root = new PathNode();
        this.stack.clear();
        this.stack.add(this.root);
    }

    @Override
    public void close() {
    }

    public void put(int n, byte k, int l) {
        this.put(n, k, l, null, null);
    }

    public void put(int n, byte k, int l, byte[] v, MetaData md) {
        if (l == 0) {
            if (v != null) {
                this.root.stats.add(v, md);
            }
            ++this.root.stats.count;
        } else {
            while (l >= this.stack.size()) {
                this.stack.add(null);
            }
            this.stack.set(l, this.stack.get(l - 1).index(n, k, v, md));
        }
    }

    public ArrayList<PathNode> root() {
        ArrayList<PathNode> out = new ArrayList<PathNode>();
        out.add(this.root);
        return out;
    }

    public static ArrayList<PathNode> parent(ArrayList<PathNode> in) {
        ArrayList<PathNode> out = new ArrayList<PathNode>();
        for (PathNode n : in) {
            if (out.contains(n.par)) continue;
            out.add(n.par);
        }
        return out;
    }

    public static ArrayList<PathNode> desc(ArrayList<PathNode> in, boolean desc) {
        ArrayList<PathNode> out = new ArrayList<PathNode>();
        for (PathNode n : in) {
            for (PathNode c : n.ch) {
                if (desc) {
                    c.addDesc(out);
                    continue;
                }
                if (out.contains(c)) continue;
                out.add(c);
            }
        }
        return out;
    }

    public ArrayList<PathNode> desc(int n, int k) {
        ArrayList<PathNode> out = new ArrayList<PathNode>();
        for (PathNode c : this.root.ch) {
            c.addDesc(out, n, k);
        }
        return out;
    }

    public TokenList desc(byte[] k, boolean d, boolean o) {
        TokenList tl = new TokenList();
        if (k.length != 0) {
            tl.add(k);
        }
        return this.desc(tl, d, o);
    }

    public TokenList desc(TokenList tl, boolean d, boolean o) {
        ArrayList<PathNode> in = PathSummary.desc(this.root(), true);
        for (byte[] i : tl) {
            boolean att = Token.startsWith(i, 64);
            byte kind = att ? (byte)3 : 1;
            int id = att ? this.data.atnindex.id(Token.substring(i, 1)) : this.data.tagindex.id(i);
            ArrayList<PathNode> out = new ArrayList<PathNode>();
            for (PathNode n : in) {
                if (n.name != id || n.kind != kind) continue;
                for (PathNode c : n.ch) {
                    if (d) {
                        c.addDesc(out);
                        continue;
                    }
                    out.add(c);
                }
            }
            in = out;
        }
        int[] tmp = new int[in.size()];
        for (int i = 0; i < in.size(); ++i) {
            tmp[i] = in.get((int)i).stats.count;
        }
        int[] occ = Array.createOrder(tmp, false);
        TokenList out = new TokenList();
        for (int i = 0; i < in.size(); ++i) {
            PathNode r = in.get(o ? occ[i] : i);
            byte[] name = r.token(this.data);
            if (name.length == 0 || out.contains(name) || Token.contains(name, 40)) continue;
            out.add(name);
        }
        if (!o) {
            out.sort(false);
        }
        return out;
    }

    @Override
    public byte[] info() {
        return this.root != null ? Token.chop(this.root.info(this.data, 0), 0x100000) : Token.EMPTY;
    }

    @Override
    public IndexIterator iter(IndexToken token) {
        throw Util.notExpected(new Object[0]);
    }

    @Override
    public int costs(IndexToken token) {
        throw Util.notExpected(new Object[0]);
    }

    @Override
    public EntryIterator entries(IndexEntries entries) {
        throw Util.notExpected(new Object[0]);
    }

    public String toString() {
        return Token.string(this.info());
    }
}

