/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.value;

import java.io.IOException;
import org.basex.data.Data;
import org.basex.index.value.DiskValues;
import org.basex.io.in.DataInput;
import org.basex.util.Token;

final class ValueIndexMerger {
    private final DiskValues dv;
    private final DataInput dk;
    private final String pref;
    private final Data data;
    byte[] key;
    byte[] values;

    ValueIndexMerger(Data d, boolean txt, int i) throws IOException {
        this.pref = (txt ? "txt" : "atv") + i;
        this.dk = new DataInput(d.meta.dbfile(this.pref + 't'));
        this.dv = new DiskValues(d, txt, this.pref);
        this.data = d;
        this.next();
    }

    void next() throws IOException {
        this.values = this.nextValues();
        if (this.values.length == 0) {
            this.dv.close();
            this.dk.close();
            this.data.meta.drop(this.pref + '.');
        } else {
            this.key = this.dk.readToken();
        }
    }

    private byte[] nextValues() {
        return this.dv.idxr.cursor() >= this.dv.idxr.length() ? Token.EMPTY : this.dv.idxl.readBytes(this.dv.idxr.read5(), this.dv.idxl.read4());
    }
}

