/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.in;

import org.basex.util.list.ByteList;

public final class TarEntry {
    private final String name;
    private final long size;
    private final byte type;

    public TarEntry(byte[] buffer) {
        String n;
        ByteList result = new ByteList();
        for (int i = 0; i < 100 && buffer[i] != 0; ++i) {
            result.add(buffer[i]);
        }
        try {
            n = new String(result.toArray());
        }
        catch (Exception ex) {
            n = result.toString();
        }
        this.name = n;
        long s = 0L;
        boolean p = true;
        for (int i = 124; i < 136; ++i) {
            byte b = buffer[i];
            if (p && (b == 32 || b == 48)) continue;
            if (b == 0 || b == 32) break;
            s = (s << 3) + (long)(b - 48);
            p = false;
        }
        this.size = s;
        this.type = buffer[156];
    }

    public long getSize() {
        return this.size;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDirectory() {
        return this.type == 53 || this.name.endsWith("/");
    }
}

