/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse;

import org.basex.data.DataText;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class XmlTokenBuilder {
    private final TokenBuilder cache = new TokenBuilder();

    public void openElement(byte[] name, byte[] ... atts) {
        this.cache.add(60).add(name);
        int al = atts.length;
        for (int a = 0; a < al; a += 2) {
            byte[] an = atts[a];
            byte[] av = atts[a + 1];
            if (av == null) continue;
            this.cache.add(32).add(an).add(61).add(34);
            this.addAttribute(av);
            this.cache.add(34);
        }
        this.cache.add(62);
    }

    public void closeElement(byte[] name) {
        this.cache.add(60).add(47).add(name).add(62);
    }

    public void addText(byte[] value) {
        int tl = value.length;
        for (int k = 0; k < tl; k += Token.cl(value, k)) {
            this.add(Token.cp(value, k));
        }
    }

    public byte[] array() {
        return this.cache.array();
    }

    private void addAttribute(byte[] value) {
        int vl = value.length;
        for (int k = 0; k < vl; k += Token.cl(value, k)) {
            int ch = Token.cp(value, k);
            if (ch == 34) {
                this.cache.add(DataText.E_QU);
                continue;
            }
            if (ch == 9 || ch == 10) {
                this.addHex(ch);
                continue;
            }
            this.add(ch);
        }
    }

    private void add(int ch) {
        if (ch < 32 && ch != 10 && ch != 9 || ch >= 127 && ch < 160) {
            this.addHex(ch);
        } else if (ch == 38) {
            this.cache.add(DataText.E_AMP);
        } else if (ch == 62) {
            this.cache.add(DataText.E_GT);
        } else if (ch == 60) {
            this.cache.add(DataText.E_LT);
        } else if (ch == 8232) {
            this.cache.add(DataText.E_2028);
        } else {
            this.cache.add(ch);
        }
    }

    private void addHex(int ch) {
        this.cache.add("&#x");
        int h = ch >> 4;
        if (h != 0) {
            this.cache.add(Token.HEX[h]);
        }
        this.cache.add(Token.HEX[ch & 0xF]).add(59);
    }
}

