/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.csv;

import org.basex.build.CsvOptions;
import org.basex.build.CsvParserOptions;
import org.basex.io.parse.csv.CsvConverter;
import org.basex.query.QueryIOException;
import org.basex.util.InputParser;
import org.basex.util.TokenBuilder;
import org.basex.util.XMLToken;

final class CsvParser
extends InputParser {
    private final CsvConverter conv;
    private final boolean header;
    private final int separator;
    private final boolean quotes;
    private boolean first = true;
    private boolean quoted;
    private boolean data;

    private CsvParser(String in, CsvParserOptions opts, CsvConverter cnv) {
        super(in);
        this.header = opts.get(CsvOptions.HEADER);
        this.separator = opts.separator();
        this.quotes = opts.get(CsvOptions.QUOTES);
        this.conv = cnv;
    }

    static void parse(String input, CsvParserOptions opts, CsvConverter conv) throws QueryIOException {
        new CsvParser(input, opts, conv).parse();
    }

    private void parse() throws QueryIOException {
        int ch;
        TokenBuilder entry = new TokenBuilder();
        boolean bl = this.data = !this.header;
        while ((ch = this.consume()) != 0) {
            if (this.quoted) {
                if (ch == 34 && !this.consume(34)) {
                    this.quoted = false;
                    continue;
                }
                entry.add(XMLToken.valid(ch) ? ch : 63);
                continue;
            }
            if (this.quotes && ch == 34) {
                this.quoted = true;
                continue;
            }
            if (ch == this.separator) {
                this.record(entry, true);
                this.first = false;
                continue;
            }
            if (ch == 10) {
                this.record(entry, !entry.isEmpty());
                this.first = true;
                this.data = true;
                continue;
            }
            entry.add(XMLToken.valid(ch) ? ch : 63);
        }
        this.record(entry, !entry.isEmpty());
    }

    private void record(TokenBuilder entry, boolean record) throws QueryIOException {
        if (record && this.first && this.data) {
            this.conv.record();
        }
        if (record || !this.first) {
            if (this.data) {
                this.conv.entry(entry.finish());
            } else {
                this.conv.header(entry.finish());
            }
            entry.reset();
        }
    }
}

