/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.json;

import org.basex.build.JsonParserOptions;
import org.basex.io.parse.json.JsonConstants;
import org.basex.io.parse.json.JsonXmlConverter;
import org.basex.query.value.node.FElem;
import org.basex.util.Token;

public final class JsonAttsConverter
extends JsonXmlConverter {
    private byte[] name;

    JsonAttsConverter(JsonParserOptions opts) {
        super(opts);
    }

    @Override
    void openObject() {
        this.addType(JsonConstants.OBJECT);
    }

    @Override
    void openPair(byte[] n) {
        FElem e = new FElem(JsonConstants.PAIR).add(JsonConstants.NAME, n);
        this.elem.add(e);
        this.elem = e;
        this.name = n;
    }

    @Override
    void closePair() {
        this.elem = (FElem)this.elem.parent();
    }

    @Override
    void closeObject() {
    }

    @Override
    void openArray() {
        this.addType(JsonConstants.ARRAY);
        this.name = null;
    }

    @Override
    void openItem() {
        FElem e = new FElem(JsonConstants.ITEM);
        this.elem.add(e);
        this.elem = e;
    }

    @Override
    void closeItem() {
        this.elem = (FElem)this.elem.parent();
    }

    @Override
    void closeArray() {
    }

    @Override
    public void openConstr(byte[] nm) {
        this.openObject();
        this.openPair(nm);
        this.openArray();
    }

    @Override
    public void openArg() {
        this.openItem();
    }

    @Override
    public void closeArg() {
        this.closeItem();
    }

    @Override
    public void closeConstr() {
        this.closeArray();
        this.closePair();
        this.closeObject();
    }

    @Override
    public void numberLit(byte[] value) {
        this.addType(JsonConstants.NUMBER).add(value);
    }

    @Override
    public void stringLit(byte[] value) {
        this.addType(JsonConstants.STRING).add(value);
    }

    @Override
    public void nullLit() {
        this.addType(Token.NULL);
    }

    @Override
    public void booleanLit(byte[] value) {
        this.addType(JsonConstants.BOOLEAN).add(value);
    }

    private FElem addType(byte[] type) {
        FElem e = this.element();
        this.addType(e, this.name, type);
        return e;
    }
}

