/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.json;

import java.io.IOException;
import org.basex.build.JsonOptions;
import org.basex.build.JsonParserOptions;
import org.basex.io.IO;
import org.basex.io.in.NewlineInput;
import org.basex.io.parse.json.JsonAttsConverter;
import org.basex.io.parse.json.JsonDirectConverter;
import org.basex.io.parse.json.JsonMLConverter;
import org.basex.io.parse.json.JsonMapConverter;
import org.basex.io.parse.json.JsonParser;
import org.basex.query.QueryIOException;
import org.basex.query.value.item.Item;
import org.basex.util.Token;

public abstract class JsonConverter {
    final JsonParserOptions jopts;

    JsonConverter(JsonParserOptions opts) {
        this.jopts = opts;
    }

    public void convert(IO input) throws IOException {
        String encoding = this.jopts.get(JsonParserOptions.ENCODING);
        this.convert(new NewlineInput(input).encoding(encoding).content(), input.path());
    }

    public void convert(byte[] input, String path) throws QueryIOException {
        JsonParser.parse(Token.string(input), path, this.jopts, this);
    }

    public static JsonConverter get(JsonParserOptions jopts) {
        switch (jopts.get(JsonOptions.FORMAT)) {
            case JSONML: {
                return new JsonMLConverter(jopts);
            }
            case ATTRIBUTES: {
                return new JsonAttsConverter(jopts);
            }
            case MAP: {
                return new JsonMapConverter(jopts);
            }
        }
        return new JsonDirectConverter(jopts);
    }

    abstract void openObject() throws QueryIOException;

    abstract void openPair(byte[] var1) throws QueryIOException;

    abstract void closePair() throws QueryIOException;

    abstract void closeObject();

    abstract void openArray() throws QueryIOException;

    abstract void openItem();

    abstract void closeItem() throws QueryIOException;

    abstract void closeArray() throws QueryIOException;

    abstract void openConstr(byte[] var1) throws QueryIOException;

    abstract void openArg();

    abstract void closeArg() throws QueryIOException;

    abstract void closeConstr() throws QueryIOException;

    abstract void numberLit(byte[] var1) throws QueryIOException;

    abstract void stringLit(byte[] var1) throws QueryIOException;

    abstract void nullLit() throws QueryIOException;

    abstract void booleanLit(byte[] var1) throws QueryIOException;

    public abstract Item finish();
}

