/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial;

import java.io.IOException;
import org.basex.io.serial.Serializer;
import org.basex.query.value.item.Item;
import org.basex.util.Atts;
import org.basex.util.Token;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public final class SAXSerializer
extends Serializer
implements XMLReader {
    private final Item item;
    private ContentHandler contentHandler;
    private EntityResolver entityResolver;
    private DTDHandler dtdHandler;
    private ErrorHandler errorHandler;
    private LexicalHandler lexicalHandler;
    private final Atts attributes = new Atts();
    private NSDecl namespaces;

    public SAXSerializer(Item it) {
        this.item = it;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public boolean getFeature(String name) {
        return false;
    }

    @Override
    public Object getProperty(String name) {
        return null;
    }

    @Override
    public void parse(InputSource input) throws SAXException {
        this.parse("");
    }

    @Override
    public void parse(String id) throws SAXException {
        try {
            this.contentHandler.startDocument();
            this.serialize(this.item);
            this.contentHandler.endDocument();
        }
        catch (Exception ex) {
            throw new SAXException(ex);
        }
    }

    @Override
    public void setContentHandler(ContentHandler ch) {
        this.contentHandler = ch;
    }

    public void setLexicalHandler(LexicalHandler lh) {
        this.lexicalHandler = lh;
    }

    @Override
    public void setEntityResolver(EntityResolver er) {
        this.entityResolver = er;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    @Override
    public void setDTDHandler(DTDHandler dtd) {
        this.dtdHandler = dtd;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler eh) {
        this.errorHandler = eh;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException {
        throw new SAXNotRecognizedException();
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException {
        throw new SAXNotRecognizedException();
    }

    @Override
    protected void startOpen(byte[] n) {
        this.namespaces = new NSDecl(this.namespaces);
        this.attributes.clear();
    }

    @Override
    protected void attribute(byte[] n, byte[] v) {
        byte[] prefix = null;
        if (Token.startsWith(n, Token.XMLNS)) {
            if (n.length == 5) {
                prefix = Token.EMPTY;
            } else if (n[5] == 58) {
                prefix = Token.substring(n, 6);
            }
        }
        if (prefix != null) {
            this.namespaces.put(prefix, v);
        } else {
            this.attributes.add(n, v);
        }
    }

    @Override
    protected void finishOpen() throws IOException {
        try {
            AttributesImpl attrs = new AttributesImpl();
            int as = this.attributes.size();
            for (int a = 0; a < as; ++a) {
                byte[] name = this.attributes.name(a);
                String uri = Token.string(this.namespaces.get(Token.prefix(name)));
                String lname = Token.string(Token.local(name));
                String rname = Token.string(name);
                String value = Token.string(this.attributes.value(a));
                attrs.addAttribute(uri, lname, rname, null, value);
            }
            String uri = Token.string(this.namespaces.get(Token.prefix(this.tag)));
            String lname = Token.string(Token.local(this.tag));
            String rname = Token.string(this.tag);
            this.contentHandler.startElement(uri, lname, rname, attrs);
        }
        catch (SAXException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    protected void finishEmpty() throws IOException {
        this.finishOpen();
        this.finishClose();
    }

    @Override
    protected void finishClose() throws IOException {
        try {
            String name = Token.string(this.tag);
            this.contentHandler.endElement("", name, name);
            this.namespaces = this.namespaces.getParent();
        }
        catch (SAXException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    protected void finishText(byte[] text) throws IOException {
        try {
            String s = Token.string(text);
            char[] c = s.toCharArray();
            this.contentHandler.characters(c, 0, c.length);
        }
        catch (SAXException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    protected void finishComment(byte[] comment) throws IOException {
        if (this.lexicalHandler != null) {
            try {
                String s = Token.string(comment);
                char[] c = s.toCharArray();
                this.lexicalHandler.comment(c, 0, c.length);
            }
            catch (SAXException ex) {
                throw new IOException(ex);
            }
        }
    }

    @Override
    protected void finishPi(byte[] n, byte[] v) throws IOException {
        try {
            this.contentHandler.processingInstruction(Token.string(n), Token.string(v));
        }
        catch (SAXException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    protected void atomic(Item i, boolean iter) {
    }

    static class NSDecl {
        private final NSDecl parent;
        private Atts decls;

        NSDecl(NSDecl par) {
            this.parent = par;
        }

        NSDecl getParent() {
            return this.parent;
        }

        void put(byte[] prefix, byte[] uri) {
            if (this.decls == null) {
                this.decls = new Atts();
            }
            this.decls.add(prefix, uri);
        }

        byte[] get(byte[] prefix) {
            NSDecl c = this;
            while (c != null) {
                byte[] ns;
                if (c.decls != null && (ns = c.decls.value(prefix)) != null) {
                    return ns;
                }
                c = c.parent;
            }
            return Token.EMPTY;
        }
    }
}

