/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.build.CsvOptions;
import org.basex.build.JsonOptions;
import org.basex.build.JsonSerialOptions;
import org.basex.data.Data;
import org.basex.data.DataText;
import org.basex.data.FTPos;
import org.basex.data.FTPosData;
import org.basex.io.serial.HTMLSerializer;
import org.basex.io.serial.RawSerializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.io.serial.TextSerializer;
import org.basex.io.serial.XHTMLSerializer;
import org.basex.io.serial.XMLSerializer;
import org.basex.io.serial.csv.CsvDirectSerializer;
import org.basex.io.serial.csv.CsvMapSerializer;
import org.basex.io.serial.json.JsonMLSerializer;
import org.basex.io.serial.json.JsonMapSerializer;
import org.basex.io.serial.json.JsonNodeSerializer;
import org.basex.query.QueryText;
import org.basex.query.iter.AxisMoreIter;
import org.basex.query.util.Err;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FTPosNode;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Type;
import org.basex.util.Atts;
import org.basex.util.Token;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.BoolList;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

public abstract class Serializer {
    public static final SerializerOptions OPTIONS = new SerializerOptions();
    protected final TokenList tags = new TokenList();
    protected int level;
    protected byte[] tag;
    boolean undecl;
    protected boolean indent;
    private final Atts nspaces = new Atts(Token.XML, QueryText.XMLURI).add(Token.EMPTY, Token.EMPTY);
    private final IntList nstack = new IntList();
    private boolean opening;

    public static XMLSerializer get(OutputStream os) throws IOException {
        return new XMLSerializer(os, OPTIONS);
    }

    public static Serializer get(OutputStream os, SerializerOptions sopts) throws IOException {
        if (sopts == null) {
            return Serializer.get(os);
        }
        switch (sopts.get(SerializerOptions.METHOD)) {
            case XHTML: {
                return new XHTMLSerializer(os, sopts);
            }
            case HTML: {
                return new HTMLSerializer(os, sopts);
            }
            case TEXT: {
                return new TextSerializer(os, sopts);
            }
            case RAW: {
                return new RawSerializer(os, sopts);
            }
            case CSV: {
                CsvOptions copts = sopts.get(SerializerOptions.CSV);
                CsvOptions.CsvFormat cform = copts.get(CsvOptions.FORMAT);
                return cform == CsvOptions.CsvFormat.MAP ? new CsvMapSerializer(os, sopts) : new CsvDirectSerializer(os, sopts);
            }
            case JSON: {
                JsonSerialOptions jopts = sopts.get(SerializerOptions.JSON);
                JsonOptions.JsonFormat jform = jopts.get(JsonOptions.FORMAT);
                return jform == JsonOptions.JsonFormat.JSONML ? new JsonMLSerializer(os, sopts) : (jform == JsonOptions.JsonFormat.MAP ? new JsonMapSerializer(os, sopts) : new JsonNodeSerializer(os, sopts));
            }
        }
        return new XMLSerializer(os, sopts);
    }

    public void serialize(Item item) throws IOException {
        this.serialize(item, false);
    }

    public void serialize(Item item, boolean atts) throws IOException {
        this.serialize(item, atts, false);
    }

    public void serialize(Item item, boolean atts, boolean iter) throws IOException {
        this.openResult();
        if (item instanceof ANode) {
            Type type = item.type;
            if (!atts) {
                if (type == NodeType.ATT) {
                    throw Err.SERATTR.getIO(item);
                }
                if (type == NodeType.NSP) {
                    throw Err.SERNS.getIO(item);
                }
            }
            this.serialize((ANode)item);
        } else {
            if (item instanceof FItem) {
                throw Err.SERFUNC.getIO(item.type());
            }
            this.finishElement();
            this.atomic(item, iter);
        }
        this.closeResult();
    }

    public void close() throws IOException {
    }

    public boolean finished() {
        return false;
    }

    public void reset() {
    }

    final void startElement(byte[] name) throws IOException {
        this.finishElement();
        this.nstack.push(this.nspaces.size());
        this.opening = true;
        this.tag = name;
        this.startOpen(name);
    }

    final void closeElement() throws IOException {
        this.nspaces.size(this.nstack.pop());
        if (this.opening) {
            this.finishEmpty();
            this.opening = false;
        } else {
            this.tag = this.tags.pop();
            --this.level;
            this.finishClose();
        }
    }

    void finishText(byte[] value, FTPos ftp) throws IOException {
        this.text(value);
    }

    final byte[] nsUri(byte[] pref) {
        for (int n = this.nspaces.size() - 1; n >= 0; --n) {
            if (!Token.eq(this.nspaces.name(n), pref)) continue;
            return this.nspaces.value(n);
        }
        return null;
    }

    protected void namespace(byte[] pref, byte[] uri) throws IOException {
        if (!this.undecl && pref.length != 0 && uri.length == 0) {
            return;
        }
        byte[] u = this.nsUri(pref);
        if (u == null || !Token.eq(u, uri)) {
            this.attribute(pref.length == 0 ? Token.XMLNS : Token.concat(Token.XMLNSC, pref), uri);
            this.nspaces.add(pref, uri);
        }
    }

    void openResult() throws IOException {
    }

    void closeResult() throws IOException {
    }

    void openDoc(byte[] name) throws IOException {
    }

    void closeDoc() throws IOException {
    }

    protected abstract void attribute(byte[] var1, byte[] var2) throws IOException;

    protected abstract void startOpen(byte[] var1) throws IOException;

    protected abstract void finishOpen() throws IOException;

    protected abstract void finishEmpty() throws IOException;

    protected abstract void finishClose() throws IOException;

    protected abstract void finishText(byte[] var1) throws IOException;

    protected abstract void finishComment(byte[] var1) throws IOException;

    protected abstract void finishPi(byte[] var1, byte[] var2) throws IOException;

    protected abstract void atomic(Item var1, boolean var2) throws IOException;

    private void serialize(ANode node) throws IOException {
        if (node instanceof DBNode) {
            this.serialize((DBNode)node);
        } else {
            Type type = node.type;
            if (type == NodeType.COM) {
                this.comment(node.string());
            } else if (type == NodeType.TXT) {
                this.text(node.string());
            } else if (type == NodeType.PI) {
                this.pi(node.name(), node.string());
            } else if (type == NodeType.ATT) {
                this.attribute(node.name(), node.string());
            } else if (type == NodeType.NSP) {
                this.namespace(node.name(), node.string());
            } else if (type == NodeType.DOC) {
                this.openDoc(node.baseURI());
                for (ANode n : node.children()) {
                    this.serialize(n);
                }
                this.closeDoc();
            } else {
                ANode n;
                ANode nd;
                QNm name = node.qname();
                this.startElement(name.string());
                Atts nsp = node.namespaces();
                for (int p = nsp.size() - 1; p >= 0; --p) {
                    this.namespace(nsp.name(p), nsp.value(p));
                }
                this.namespace(name.prefix(), name.uri());
                boolean i = this.indent;
                AxisMoreIter ai = node.attributes();
                while ((nd = ai.next()) != null) {
                    byte[] n2 = nd.name();
                    byte[] v = nd.string();
                    this.attribute(n2, v);
                    if (!Token.eq(n2, DataText.XML_SPACE)) continue;
                    this.indent &= Token.eq(v, DataText.DEFAULT);
                }
                ai = node.children();
                while ((n = ai.next()) != null) {
                    this.serialize(n);
                }
                this.indent = i;
                this.closeElement();
            }
        }
    }

    private void serialize(DBNode node) throws IOException {
        FTPosData ft = node instanceof FTPosNode ? ((FTPosNode)node).ft : null;
        Data data = node.data;
        int p = node.pre;
        int k = data.kind(p);
        if (k == 3) {
            throw Err.SERATTR.getIO(node);
        }
        boolean doc = false;
        TokenSet nsp = data.nspaces.size() == 0 ? null : new TokenSet();
        IntList pars = new IntList();
        BoolList indt = new BoolList();
        int s = p + data.size(p, k);
        while (p < s && !this.finished()) {
            k = data.kind(p);
            int r = data.parent(p, k);
            while (!pars.isEmpty() && pars.peek() >= r) {
                this.closeElement();
                this.indent = indt.pop();
                pars.pop();
            }
            if (k == 0) {
                if (doc) {
                    this.closeDoc();
                }
                this.openDoc(data.text(p++, true));
                doc = true;
                continue;
            }
            if (k == 2) {
                FTPos ftd;
                FTPos fTPos = ftd = ft != null ? ft.get(data, p) : null;
                if (ftd != null) {
                    this.text(data.text(p++, true), ftd);
                    continue;
                }
                this.text(data.text(p++, true));
                continue;
            }
            if (k == 4) {
                this.comment(data.text(p++, true));
                continue;
            }
            if (k == 5) {
                this.pi(data.name(p, 5), data.atom(p++));
                continue;
            }
            byte[] name = data.name(p, k);
            this.startElement(name);
            if (nsp != null) {
                nsp.clear();
                int pp = p;
                byte[] u = data.nspaces.uri(data.uri(p, k));
                this.namespace(Token.prefix(name), u == null ? Token.EMPTY : u);
                do {
                    Atts ns = data.ns(pp);
                    for (int n = 0; n < ns.size(); ++n) {
                        byte[] pref = ns.name(n);
                        if (!nsp.add(pref)) continue;
                        this.namespace(pref, ns.value(n));
                    }
                } while (this.level == 0 && (pp = data.parent(pp, data.kind(pp))) >= 0 && data.kind(pp) == 1);
            }
            indt.push(this.indent);
            int as = p + data.attSize(p, k);
            while (++p != as) {
                byte[] n = data.name(p, 3);
                byte[] v = data.text(p, false);
                this.attribute(n, v);
                if (!Token.eq(n, DataText.XML_SPACE)) continue;
                this.indent &= Token.eq(v, DataText.DEFAULT);
            }
            pars.push(r);
        }
        while (!pars.isEmpty()) {
            this.closeElement();
            this.indent = indt.pop();
            pars.pop();
        }
        if (doc) {
            this.closeDoc();
        }
    }

    private void text(byte[] v, FTPos ftp) throws IOException {
        this.finishElement();
        this.finishText(v, ftp);
    }

    private void comment(byte[] value) throws IOException {
        this.finishElement();
        this.finishComment(value);
    }

    private void text(byte[] value) throws IOException {
        this.finishElement();
        this.finishText(value);
    }

    private void pi(byte[] name, byte[] value) throws IOException {
        this.finishElement();
        this.finishPi(name, value);
    }

    private void finishElement() throws IOException {
        if (!this.opening) {
            return;
        }
        this.opening = false;
        this.finishOpen();
        this.tags.push(this.tag);
        ++this.level;
    }
}

