/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import java.io.IOException;
import java.util.HashMap;
import org.basex.build.DirParser;
import org.basex.core.Context;
import org.basex.core.Datas;
import org.basex.core.MainOptions;
import org.basex.core.Perm;
import org.basex.core.Text;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.CreateDB;
import org.basex.core.cmd.Open;
import org.basex.data.Data;
import org.basex.data.Nodes;
import org.basex.io.IO;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.seq.DBNodeSeq;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.type.NodeType;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.Prop;
import org.basex.util.QueryInput;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.IntList;
import org.basex.util.options.Option;

public final class QueryResources {
    public final HashMap<String, String[]> resources = new HashMap();
    public boolean openDB = true;
    private final QueryContext ctx;
    private Data[] data = new Data[1];
    private int datas;
    private Value[] coll = new Value[1];
    private String[] collName = new String[1];
    private int colls;

    QueryResources(QueryContext qc) {
        this.ctx = qc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void compile(Nodes nodes) throws QueryException {
        Data d = nodes.data;
        if (!this.ctx.context.perm(Perm.READ, d.meta)) {
            throw Err.BASX_PERM.get(null, new Object[]{Perm.READ});
        }
        boolean root = nodes.root;
        this.ctx.value = DBNodeSeq.get(new IntList(nodes.pres), d, root, root);
        this.addCollection(root ? this.ctx.value : DBNodeSeq.get(d.resources.docs(), d, true, true), d.meta.name);
        this.add(d);
        Datas datas = this.ctx.context.dbs;
        synchronized (datas) {
            this.ctx.context.dbs.pin(d);
        }
    }

    void close() {
        for (int d = 0; d < this.datas; ++d) {
            Close.close(this.data[d], this.ctx.context);
        }
        this.datas = 0;
    }

    public Data database(String name, InputInfo info) throws QueryException {
        for (int d = 0; d < this.datas; ++d) {
            if (this.data[d].inMemory()) continue;
            String n = this.data[d].meta.name;
            if (!(Prop.CASE ? n.equals(name) : n.equalsIgnoreCase(name))) continue;
            return this.data[d];
        }
        if (!this.openDB) {
            throw Err.BXXQ_NEWDB.get(info, new Object[0]);
        }
        try {
            return this.add(Open.open(name, this.ctx.context));
        }
        catch (IOException ex) {
            throw Err.BXDB_OPEN.get(info, ex);
        }
    }

    public DBNode doc(QueryInput qi, IO baseIO, InputInfo info) throws QueryException {
        if (this.ctx.context.options.get(MainOptions.DEFAULTDB).booleanValue() && this.ctx.nodes != null) {
            Data dt = this.data[0];
            int pre = dt.resources.doc(qi.original);
            if (pre != -1) {
                return new DBNode(dt, pre, 0);
            }
        }
        for (int d = 0; d < this.datas; ++d) {
            Data dt = this.data[d];
            if (dt.resources.docs().size() == 1 && IO.get(dt.meta.original).eq(qi.input)) {
                return new DBNode(dt, 0, 0);
            }
            String n = dt.meta.name;
            if (!(Prop.CASE ? n.equals(qi.db) : n.equalsIgnoreCase(qi.db))) continue;
            return QueryResources.doc(dt, qi, info);
        }
        Data dt = this.open(qi);
        if (dt == null) {
            dt = this.create(qi, true, baseIO, info);
        }
        return QueryResources.doc(dt, qi, info);
    }

    public Value collection(InputInfo info) throws QueryException {
        if (this.colls == 0) {
            throw Err.NODEFCOLL.get(info, new Object[0]);
        }
        return this.coll[0];
    }

    public Value collection(QueryInput qi, IO baseIO, InputInfo info) throws QueryException {
        String in;
        if (this.ctx.context.options.get(MainOptions.DEFAULTDB).booleanValue() && this.ctx.nodes != null) {
            Data dt = this.data[0];
            IntList pres = dt.resources.docs(qi.original);
            return DBNodeSeq.get(pres, dt, true, qi.original.isEmpty());
        }
        String string = in = baseIO != null ? baseIO.merge(qi.original).path() : null;
        if (in != null) {
            String[] names = new String[]{in, qi.original};
            for (int c = 0; c < this.colls; ++c) {
                String n = this.collName[c];
                if (!(Prop.CASE ? Token.eq(n, names) : Token.eqic(n, names))) continue;
                return this.coll[c];
            }
        }
        Data dt = null;
        for (int i = 0; i < this.datas; ++i) {
            Data d = this.data[i];
            String n = d.meta.name;
            if (!(Prop.CASE ? n.equals(qi.db) : n.equalsIgnoreCase(qi.db) || IO.get(d.meta.original).eq(qi.input))) continue;
            dt = d;
            break;
        }
        if (dt == null) {
            dt = this.open(qi);
        }
        if (dt == null) {
            dt = this.create(qi, false, baseIO, info);
        }
        return DBNodeSeq.get(dt.resources.docs(qi.path), dt, true, qi.path.isEmpty());
    }

    public void addDoc(String name, String path, IO baseIO) throws QueryException {
        QueryInput qi = new QueryInput(path);
        Data d = this.create(qi, true, baseIO, null);
        if (name != null) {
            d.meta.original = name;
        }
    }

    public void addResource(String uri, String ... strings) {
        this.resources.put(uri, strings);
    }

    public void addCollection(String name, String[] paths, IO baseIO) throws QueryException {
        int ns = paths.length;
        Item[] nodes = new DBNode[ns];
        for (int n = 0; n < ns; ++n) {
            QueryInput qi = new QueryInput(paths[n]);
            nodes[n] = new DBNode(this.create(qi, true, baseIO, null), 0, 0);
        }
        this.addCollection(Seq.get(nodes, ns, NodeType.DOC), name);
    }

    private Data open(QueryInput input) {
        if (this.openDB && input.db != null) {
            try {
                return this.add(Open.open(input.db, this.ctx.context));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private Data create(QueryInput input, boolean single, IO baseIO, InputInfo info) throws QueryException {
        Context context = this.ctx.context;
        boolean force = context.options.get(MainOptions.FORCECREATE);
        if (force && !this.openDB) {
            throw Err.BXXQ_NEWDB.get(info, new Object[0]);
        }
        if (!context.user.has(Perm.READ)) {
            throw Err.BXXQ_PERM.get(info, Util.info(Text.PERM_REQUIRED_X, new Object[]{Perm.READ}));
        }
        IO source = QueryResources.checkPath(input, baseIO, info);
        if (single && source.isDir()) {
            Err.WHICHRES.get(info, baseIO);
        }
        MainOptions opts = context.options;
        Option[] options = new Option[]{MainOptions.SKIPCORRUPT, MainOptions.ADDARCHIVES, MainOptions.ADDRAW, MainOptions.PARSER, MainOptions.CREATEFILTER};
        Object[] values = new Object[options.length];
        int ol = options.length;
        for (int o = 0; o < ol; ++o) {
            Option option = options[o];
            values[o] = opts.get(option);
            opts.put(option, option.value());
        }
        try {
            Data o = this.add(CreateDB.create(source.dbname(), new DirParser(source, opts), context, !force));
            return o;
        }
        catch (IOException ex) {
            throw Err.IOERR.get(info, ex);
        }
        finally {
            for (int o = 0; o < ol; ++o) {
                opts.put(options[o], values[o]);
            }
            input.path = "";
        }
    }

    public static IO checkPath(QueryInput input, IO baseIO, InputInfo info) throws QueryException {
        IO in = input.input;
        if (in.exists()) {
            return in;
        }
        if (baseIO != null && !(in = baseIO.merge(input.original)).path().equals(input.original) && in.exists()) {
            return in;
        }
        throw Err.WHICHRES.get(info, in);
    }

    private static DBNode doc(Data dt, QueryInput qi, InputInfo info) throws QueryException {
        IntList docs = dt.resources.docs(qi.path);
        if (docs.size() == 1) {
            return new DBNode(dt, docs.get(0), 0);
        }
        throw (docs.isEmpty() ? Err.BXDB_NODOC : Err.BXDB_SINGLE).get(info, qi.original);
    }

    private Data add(Data d) {
        if (this.datas == this.data.length) {
            this.data = Array.copy(this.data, new Data[Array.newSize(this.datas)]);
        }
        this.data[this.datas++] = d;
        return d;
    }

    public void remove(String name) {
        int d;
        int n = d = this.ctx.nodes != null ? 1 : 0;
        while (d < this.datas) {
            if (this.data[d].meta.name.equals(name)) {
                Close.close(this.data[d], this.ctx.context);
                Array.move(this.data, d + 1, -1, --this.datas - d);
                this.data[this.datas] = null;
                break;
            }
            ++d;
        }
    }

    private void addCollection(Value nodes, String name) {
        if (this.colls == this.coll.length) {
            int s = Array.newSize(this.colls);
            this.coll = Array.copy(this.coll, new Value[s]);
            this.collName = Array.copyOf(this.collName, s);
        }
        this.coll[this.colls] = nodes;
        this.collName[this.colls++] = name;
    }
}

