/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.CName;
import org.basex.query.expr.Expr;
import org.basex.query.util.Err;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FPI;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.XMLToken;
import org.basex.util.hash.IntObjMap;

public final class CPI
extends CName {
    public CPI(StaticContext sctx, InputInfo ii, Expr n, Expr v) {
        super("processing-instruction", sctx, ii, n, v);
        this.type = SeqType.PI;
    }

    @Override
    public FPI item(QueryContext ctx, InputInfo ii) throws QueryException {
        Item it = this.checkItem(this.name, ctx);
        Type ip = it.type;
        if (!ip.isStringOrUntyped() && ip != AtomType.QNM) {
            throw Err.CPIWRONG.get(this.info, it);
        }
        byte[] nm = Token.trim(it.string(ii));
        if (Token.eq(Token.lc(nm), Token.XML)) {
            throw Err.CPIXML.get(this.info, new Object[]{nm});
        }
        if (!XMLToken.isNCName(nm)) {
            throw Err.CPIINVAL.get(this.info, new Object[]{nm});
        }
        byte[] v = this.value(ctx, ii);
        int i = -1;
        while (++i != v.length && v[i] >= 0 && v[i] <= 32) {
        }
        v = Token.substring(v, i);
        return new FPI(new QNm(nm), FPI.parse(v, this.info));
    }

    @Override
    public Expr copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        return new CPI(this.sc, this.info, this.name.copy(ctx, scp, vs), this.expr[0].copy(ctx, scp, vs));
    }
}

