/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.iter.Iter;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.BlnSeq;
import org.basex.query.value.seq.BytSeq;
import org.basex.query.value.seq.DblSeq;
import org.basex.query.value.seq.DecSeq;
import org.basex.query.value.seq.FltSeq;
import org.basex.query.value.seq.IntSeq;
import org.basex.query.value.seq.StrSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class List
extends Arr {
    private static final int MAX_MAT_SIZE = 0x100000;

    public List(InputInfo ii, Expr ... l) {
        super(ii, l);
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkAllUp(this.expr);
    }

    @Override
    public Expr compile(QueryContext ctx, VarScope scp) throws QueryException {
        int es = this.expr.length;
        for (int e = 0; e < es; ++e) {
            this.expr[e] = this.expr[e].compile(ctx, scp);
        }
        return this.optimize(ctx, scp);
    }

    @Override
    public Expr optimize(QueryContext ctx, VarScope scp) throws QueryException {
        this.size = 0L;
        boolean ne = false;
        for (Expr e : this.expr) {
            long c = e.size();
            ne |= c > 0L || e.type().occ.min == 1;
            if (c == -1L) {
                this.size = -1L;
                break;
            }
            if (this.size < 0L) continue;
            this.size += c;
        }
        if (this.size >= 0L) {
            if (this.size == 0L && !this.has(Expr.Flag.NDT) && !this.has(Expr.Flag.UPD)) {
                return this.optPre(null, ctx);
            }
            if (this.allAreValues() && this.size <= 0x100000L) {
                Value val;
                Type all = null;
                Value[] vs = new Value[this.expr.length];
                int c = 0;
                for (Expr e : this.expr) {
                    Value v = e.value(ctx);
                    if (c == 0) {
                        all = v.type;
                    } else if (all != v.type) {
                        all = null;
                    }
                    vs[c++] = v;
                }
                int s = (int)this.size;
                if (all == AtomType.STR) {
                    val = StrSeq.get(vs, s);
                } else if (all == AtomType.BLN) {
                    val = BlnSeq.get(vs, s);
                } else if (all == AtomType.FLT) {
                    val = FltSeq.get(vs, s);
                } else if (all == AtomType.DBL) {
                    val = DblSeq.get(vs, s);
                } else if (all == AtomType.DEC) {
                    val = DecSeq.get(vs, s);
                } else if (all == AtomType.BYT) {
                    val = BytSeq.get(vs, s);
                } else if (all != null && all.instanceOf(AtomType.ITR)) {
                    val = IntSeq.get(vs, s, all);
                } else {
                    ValueBuilder vb = new ValueBuilder(s);
                    for (int i = 0; i < c; ++i) {
                        vb.add(vs[i]);
                    }
                    val = vb.value();
                }
                return this.optPre(val, ctx);
            }
        }
        if (this.size == 0L) {
            this.type = SeqType.EMP;
        } else {
            SeqType.Occ o = this.size == 1L ? SeqType.Occ.ONE : (this.size < 0L && !ne ? SeqType.Occ.ZERO_MORE : SeqType.Occ.ONE_MORE);
            SeqType t = null;
            for (Expr e : this.expr) {
                SeqType st = e.type();
                if (e.isEmpty() || st.occ == SeqType.Occ.ZERO) continue;
                t = t == null ? st : t.union(st);
            }
            this.type = SeqType.get(t == null ? AtomType.ITEM : t.type, o);
        }
        return this;
    }

    @Override
    public Iter iter(final QueryContext ctx) {
        return new Iter(){
            Iter ir;
            int e;

            @Override
            public Item next() throws QueryException {
                while (true) {
                    Item it;
                    if (this.ir == null) {
                        if (this.e == List.this.expr.length) {
                            return null;
                        }
                        this.ir = ctx.iter(List.this.expr[this.e++]);
                    }
                    if ((it = this.ir.next()) != null) {
                        return it;
                    }
                    this.ir = null;
                }
            }
        };
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        ValueBuilder vb = new ValueBuilder();
        for (Expr e : this.expr) {
            vb.add(ctx.value(e));
        }
        return vb.value();
    }

    @Override
    public Expr copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        return this.copyType(new List(this.info, List.copyAll((QueryContext)ctx, (VarScope)scp, vs, (Expr[])this.expr)));
    }

    @Override
    public boolean isVacuous() {
        for (Expr e : this.expr) {
            if (e.isVacuous()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return this.toString(", ");
    }
}

