/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.data.ExprInfo;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Simple;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Bln;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class Pos
extends Simple {
    final long min;
    final long max;

    private Pos(long mn, long mx, InputInfo ii) {
        super(ii);
        this.min = mn;
        this.max = mx;
        this.type = SeqType.BLN;
    }

    public static Expr get(long mn, long mx, InputInfo ii) {
        return mn > mx || mx < 1L ? Bln.FALSE : (mn <= 1L && mx == Long.MAX_VALUE ? Bln.TRUE : new Pos(mn, mx, ii));
    }

    public static Expr get(CmpV.OpV cmp, Expr a, Expr o, InputInfo ii) {
        if (a instanceof ANum) {
            ANum it = (ANum)a;
            long p = it.itr();
            boolean ex = (double)p == it.dbl();
            switch (cmp) {
                case EQ: {
                    return ex ? Pos.get(p, p, ii) : Bln.FALSE;
                }
                case GE: {
                    return Pos.get(ex ? p : p + 1L, Long.MAX_VALUE, ii);
                }
                case GT: {
                    return Pos.get(p + 1L, Long.MAX_VALUE, ii);
                }
                case LE: {
                    return Pos.get(1L, p, ii);
                }
                case LT: {
                    return Pos.get(1L, ex ? p - 1L : p, ii);
                }
            }
        }
        return o;
    }

    @Override
    public Bln item(QueryContext ctx, InputInfo ii) throws QueryException {
        this.checkCtx(ctx);
        return Bln.get(ctx.pos >= this.min && ctx.pos <= this.max);
    }

    @Override
    public Pos copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        return new Pos(this.min, this.max, this.info);
    }

    public boolean skip(QueryContext ctx) {
        return ctx.pos >= this.max;
    }

    Expr intersect(Pos pos, InputInfo ii) {
        return Pos.get(Math.max(this.min, pos.min), Math.min(this.max, pos.max), ii);
    }

    @Override
    public boolean has(Expr.Flag flag) {
        return flag == Expr.Flag.FCS;
    }

    @Override
    public boolean sameAs(Expr cmp) {
        if (!(cmp instanceof Pos)) {
            return false;
        }
        Pos p = (Pos)cmp;
        return this.min == p.min && this.max == p.max;
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(QueryText.MIN, this.min, QueryText.MAX, this.max == Long.MAX_VALUE ? QueryText.INF : (byte[])this.max), new ExprInfo[0]);
    }

    @Override
    public String toString() {
        if (this.min == this.max) {
            return Long.toString(this.min);
        }
        StringBuilder sb = new StringBuilder("position() ");
        if (this.max == Long.MAX_VALUE) {
            sb.append('>');
        }
        sb.append("= ").append(this.min);
        if (this.max != Long.MAX_VALUE) {
            sb.append(" to ").append(this.max);
        }
        return sb.toString();
    }
}

