/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.data.Data;
import org.basex.data.ExprInfo;
import org.basex.index.IndexType;
import org.basex.index.query.IndexIterator;
import org.basex.index.query.StringRange;
import org.basex.query.QueryContext;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.expr.IndexAccess;
import org.basex.query.func.Function;
import org.basex.query.iter.AxisIter;
import org.basex.query.util.IndexContext;
import org.basex.query.value.item.Str;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FElem;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.hash.IntObjMap;

public final class StringRangeAccess
extends IndexAccess {
    private final StringRange sr;

    public StringRangeAccess(InputInfo ii, StringRange t, IndexContext ic) {
        super(ic, ii);
        this.sr = t;
    }

    @Override
    public AxisIter iter(QueryContext ctx) {
        boolean text = this.sr.type == IndexType.TEXT;
        final byte kind = text ? (byte)2 : 3;
        final Data data = this.ictx.data;
        int ml = data.meta.maxlen;
        final IndexIterator ii = this.sr.min.length <= ml && this.sr.max.length <= ml && (text ? data.meta.textindex : data.meta.attrindex) ? data.iter(this.sr) : this.scan();
        return new AxisIter(){

            @Override
            public ANode next() {
                return ii.more() ? new DBNode(data, ii.pre(), kind) : null;
            }
        };
    }

    private IndexIterator scan() {
        return new IndexIterator(){
            final boolean text;
            final byte kind;
            int pre;
            {
                this.text = ((StringRangeAccess)StringRangeAccess.this).sr.type == IndexType.TEXT;
                this.kind = (byte)(this.text ? 2 : 3);
                this.pre = -1;
            }

            @Override
            public int pre() {
                return this.pre;
            }

            @Override
            public boolean more() {
                Data data = StringRangeAccess.this.ictx.data;
                while (++this.pre < data.meta.size) {
                    if (data.kind(this.pre) != this.kind) continue;
                    byte[] t = data.text(this.pre, this.text);
                    int mn = Token.diff(t, ((StringRangeAccess)StringRangeAccess.this).sr.min);
                    int mx = Token.diff(t, ((StringRangeAccess)StringRangeAccess.this).sr.max);
                    if (mn < (((StringRangeAccess)StringRangeAccess.this).sr.mni ? 0 : 1) || mx > (((StringRangeAccess)StringRangeAccess.this).sr.mxi ? 0 : 1)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public int size() {
                return Math.max(1, StringRangeAccess.this.ictx.data.meta.size >>> 2);
            }
        };
    }

    @Override
    public Expr copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        return new StringRangeAccess(this.info, this.sr, this.ictx);
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(new Object[]{QueryText.DATA, this.ictx.data.meta.name, QueryText.MIN, this.sr.min, QueryText.MAX, this.sr.max, QueryText.TYP, this.sr.type}), new ExprInfo[0]);
    }

    @Override
    public String toString() {
        return (this.sr.type == IndexType.TEXT ? Function._DB_TEXT_RANGE : Function._DB_ATTRIBUTE_RANGE).get(null, this.info, Str.get(this.ictx.data.meta.name), Str.get(this.sr.min), Str.get(this.sr.max)).toString();
    }
}

