/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.expr.TypeCase;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.Value;
import org.basex.query.value.node.FElem;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.hash.IntObjMap;

public final class TypeSwitch
extends ParseExpr {
    private final TypeCase[] cases;
    private Expr ts;

    public TypeSwitch(InputInfo ii, Expr t, TypeCase[] c) {
        super(ii);
        this.ts = t;
        this.cases = c;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoUp(this.ts);
        Expr[] tmp = new Expr[this.cases.length];
        for (int i = 0; i < this.cases.length; ++i) {
            tmp[i] = this.cases[i].expr;
        }
        this.checkAllUp(tmp);
    }

    @Override
    public Expr compile(QueryContext ctx, VarScope scp) throws QueryException {
        int c;
        this.ts = this.ts.compile(ctx, scp);
        if (this.ts.isValue()) {
            Value val = this.ts.value(ctx);
            for (TypeCase tc : this.cases) {
                if (!tc.matches(val)) continue;
                return this.optPre(tc.compile((QueryContext)ctx, (VarScope)scp, (Value)((Value)this.ts)).expr, ctx);
            }
        }
        for (TypeCase tc : this.cases) {
            tc.compile(ctx, scp);
        }
        TypeCase tc = this.cases[0];
        boolean eq = tc.var == null;
        for (c = 1; eq && c < this.cases.length; ++c) {
            eq = tc.expr.sameAs(this.cases[c].expr);
        }
        if (eq) {
            return this.optPre(tc.expr, ctx);
        }
        this.type = this.cases[0].type();
        for (c = 1; c < this.cases.length; ++c) {
            this.type = this.type.union(this.cases[c].type());
        }
        return this;
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        Value seq = ctx.value(this.ts);
        for (TypeCase tc : this.cases) {
            Iter iter = tc.iter(ctx, seq);
            if (iter == null) continue;
            return iter;
        }
        throw Util.notExpected(new Object[0]);
    }

    @Override
    public boolean isVacuous() {
        for (TypeCase tc : this.cases) {
            if (tc.expr.isVacuous()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean has(Expr.Flag flag) {
        for (TypeCase tc : this.cases) {
            if (!tc.has(flag)) continue;
            return true;
        }
        return this.ts.has(flag);
    }

    @Override
    public boolean removable(Var v) {
        for (TypeCase tc : this.cases) {
            if (tc.removable(v)) continue;
            return false;
        }
        return this.ts.removable(v);
    }

    @Override
    public VarUsage count(Var v) {
        return this.ts.count(v).plus(VarUsage.maximum(v, this.cases));
    }

    @Override
    public Expr inline(QueryContext ctx, VarScope scp, Var v, Expr e) throws QueryException {
        boolean change = TypeSwitch.inlineAll(ctx, scp, this.cases, v, e);
        Expr t = this.ts.inline(ctx, scp, v, e);
        if (t != null) {
            change = true;
            this.ts = t;
        }
        return change ? this.optimize(ctx, scp) : null;
    }

    @Override
    public Expr copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        TypeCase[] cs = new TypeCase[this.cases.length];
        for (int i = 0; i < cs.length; ++i) {
            cs[i] = this.cases[i].copy(ctx, scp, (IntObjMap)vs);
        }
        return new TypeSwitch(this.info, this.ts.copy(ctx, scp, vs), cs);
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(new Object[0]), new Object[]{this.cases, this.ts});
    }

    @Override
    public String toString() {
        return new TokenBuilder("typeswitch(" + this.ts + ")" + ' ').addSep(this.cases, " ").toString();
    }

    @Override
    public void markTailCalls(QueryContext ctx) {
        for (TypeCase t : this.cases) {
            t.markTailCalls(ctx);
        }
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return this.ts.accept(visitor) && TypeSwitch.visitAll(visitor, this.cases);
    }

    @Override
    public int exprSize() {
        int sz = 1;
        for (TypeCase e : this.cases) {
            sz += ((Expr)e).exprSize();
        }
        return sz + this.ts.exprSize();
    }
}

