/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.util.Err;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Flt;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class Unary
extends Single {
    private final boolean minus;

    public Unary(InputInfo ii, Expr e, boolean min) {
        super(ii, e);
        this.minus = min;
    }

    @Override
    public Expr compile(QueryContext ctx, VarScope scp) throws QueryException {
        super.compile(ctx, scp);
        this.type = this.expr.type();
        if (!this.type.type.isNumber()) {
            this.type = this.type.mayBeZero() ? SeqType.ITR_ZO : SeqType.ITR;
        }
        return this.expr.isValue() ? this.preEval(ctx) : this;
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        Item it = this.expr.item(ctx, this.info);
        if (it == null) {
            return null;
        }
        Type ip = it.type;
        if (!ip.isNumberOrUntyped()) {
            throw Err.numberError(this, it);
        }
        double d = it.dbl(this.info);
        if (ip.isUntyped()) {
            return Dbl.get(this.minus ? -d : d);
        }
        if (!this.minus) {
            return it;
        }
        switch ((AtomType)ip) {
            case DBL: {
                return Dbl.get(-d);
            }
            case FLT: {
                return Flt.get(-it.flt(this.info));
            }
            case DEC: {
                return Dec.get(it.dec(this.info).negate());
            }
        }
        long l = it.itr(this.info);
        if (l == Long.MIN_VALUE) {
            throw Err.RANGE.get(this.info, it);
        }
        return Int.get(-l);
    }

    @Override
    public Expr copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        return this.copyType(new Unary(this.info, this.expr.copy(ctx, scp, vs), this.minus));
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(QueryText.VAL, this.minus), this.expr);
    }

    @Override
    public String toString() {
        return (this.minus ? "-" : "") + this.expr;
    }
}

