/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.ft;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.ft.FTExpr;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.item.Bln;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTOpt;

public abstract class FTContains
extends ParseExpr {
    final FTLexer lex;
    Expr expr;
    FTExpr ftexpr;

    protected FTContains(Expr e, FTExpr fte, InputInfo ii) {
        super(ii);
        this.expr = e;
        this.ftexpr = fte;
        this.type = SeqType.BLN;
        this.lex = new FTLexer(new FTOpt());
    }

    @Override
    public final void checkUp() throws QueryException {
        this.checkNoUp(this.expr);
    }

    @Override
    public final Expr compile(QueryContext ctx, VarScope scp) throws QueryException {
        this.expr = this.expr.compile(ctx, scp).addText(ctx);
        this.ftexpr = this.ftexpr.compile(ctx, scp);
        return this.expr.isEmpty() ? this.optPre(Bln.FALSE, ctx) : this;
    }

    @Override
    public final boolean has(Expr.Flag flag) {
        return this.expr.has(flag) || this.ftexpr.has(flag);
    }

    @Override
    public final boolean removable(Var v) {
        return this.expr.removable(v) && this.ftexpr.removable(v);
    }

    @Override
    public final VarUsage count(Var v) {
        return this.expr.count(v).plus(this.ftexpr.count(v));
    }

    @Override
    public final Expr inline(QueryContext ctx, VarScope scp, Var v, Expr e) throws QueryException {
        FTExpr fte;
        Expr ex = this.expr.inline(ctx, scp, v, e);
        if (ex != null) {
            this.expr = ex;
        }
        if ((fte = this.ftexpr.inline(ctx, scp, v, e)) != null) {
            this.ftexpr = fte;
        }
        return ex != null || fte != null ? this.optimize(ctx, scp) : null;
    }

    @Override
    public final void plan(FElem plan) {
        this.addPlan(plan, this.planElem(new Object[0]), this.expr, this.ftexpr);
    }

    @Override
    public final boolean accept(ASTVisitor visitor) {
        return this.expr.accept(visitor) && this.ftexpr.accept(visitor);
    }

    @Override
    public final int exprSize() {
        return this.expr.exprSize() + this.ftexpr.exprSize() + 1;
    }

    @Override
    public final String toString() {
        return this.expr + " " + "contains" + ' ' + "text" + ' ' + this.ftexpr;
    }
}

