/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.ft;

import org.basex.data.FTMatch;
import org.basex.data.FTStringMatch;
import org.basex.query.QueryContext;
import org.basex.query.ft.FTExpr;
import org.basex.query.ft.FTFilter;
import org.basex.query.value.node.FElem;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTUnit;
import org.basex.util.hash.IntObjMap;
import org.basex.util.list.BoolList;

public final class FTScope
extends FTFilter {
    private final boolean same;

    public FTScope(InputInfo ii, FTExpr e, boolean sm, FTUnit un) {
        super(ii, e, un);
        this.same = sm;
    }

    @Override
    protected boolean filter(QueryContext ctx, FTMatch mtc, FTLexer lex) {
        if (this.same) {
            int s = -1;
            for (FTStringMatch sm : mtc) {
                if (sm.exclude) continue;
                int p = this.pos(sm.start, lex);
                if (s == -1) {
                    s = p;
                    continue;
                }
                if (s == p) continue;
                return false;
            }
            return true;
        }
        int c = 0;
        BoolList bl = new BoolList();
        for (FTStringMatch sm : mtc) {
            int s;
            if (sm.exclude) continue;
            ++c;
            int p = this.pos(sm.start, lex);
            if (p < (s = bl.size()) && bl.get(p) && p == this.pos(sm.end, lex)) {
                return false;
            }
            bl.set(p, true);
        }
        return c > 1;
    }

    @Override
    public FTExpr copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        return new FTScope(this.info, (FTExpr)this.expr[0].copy(ctx, scp, (IntObjMap)vs), this.same, this.unit);
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(new Object[]{this.same ? "same" : "different", this.unit}), this.expr);
    }

    @Override
    public String toString() {
        return super.toString() + (this.same ? "same" : "different") + ' ' + (Object)((Object)this.unit);
    }
}

