/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.util.Arrays;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.expr.XQFunctionExpr;
import org.basex.query.func.FuncCall;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Ann;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.Map;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.IntObjMap;

public final class DynFuncCall
extends FuncCall {
    private int[] inlinedFrom;
    private final boolean updating;

    public DynFuncCall(InputInfo ii, boolean updating, Expr fun, Expr ... arg) {
        super(ii, Array.add(arg, fun));
        this.updating = updating;
    }

    @Override
    public Expr compile(QueryContext ctx, VarScope scp) throws QueryException {
        super.compile(ctx, scp);
        return this.optimize(ctx, scp);
    }

    @Override
    public Expr optimize(QueryContext ctx, VarScope scp) throws QueryException {
        int ar = this.expr.length - 1;
        Expr f = this.expr[ar];
        Type t = f.type().type;
        if (t instanceof FuncType) {
            FuncType ft = (FuncType)t;
            if (ft.args != null && ft.args.length != ar) {
                throw Err.INVARITY.get(this.info, f, ar);
            }
            if (ft.ret != null) {
                this.type = ft.ret;
            }
        }
        if (f instanceof XQFunctionExpr) {
            Expr[] args;
            Expr inl;
            if (this.allAreValues() && f instanceof Map) {
                return this.optPre(this.value(ctx), ctx);
            }
            if (!(f instanceof FuncItem && this.comesFrom((FuncItem)f) || this.updating || (inl = ((XQFunctionExpr)((Object)f)).inlineExpr(args = Arrays.copyOf(this.expr, this.expr.length - 1), ctx, scp, this.info)) == null)) {
                return inl;
            }
        }
        return this;
    }

    public void markInlined(FuncItem it) {
        int[] nArray;
        int hash = it.hashCode();
        if (this.inlinedFrom == null) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = hash;
        } else {
            nArray = Array.add(this.inlinedFrom, hash);
        }
        this.inlinedFrom = nArray;
    }

    private boolean comesFrom(FuncItem it) {
        if (this.inlinedFrom != null) {
            int hash = it.hashCode();
            for (int h : this.inlinedFrom) {
                if (hash != h) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Expr copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        Expr[] copy = DynFuncCall.copyAll((QueryContext)ctx, (VarScope)scp, vs, (Expr[])this.expr);
        int last = copy.length - 1;
        DynFuncCall call = new DynFuncCall(this.info, this.updating, copy[last], Arrays.copyOf(copy, last));
        if (this.inlinedFrom != null) {
            call.inlinedFrom = (int[])this.inlinedFrom.clone();
        }
        return this.copyType(call);
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return visitor.dynFuncCall(this) && DynFuncCall.visitAll(visitor, this.expr);
    }

    @Override
    public void plan(FElem plan) {
        FElem el = this.planElem(QueryText.TCL, this.tailCall);
        int es = this.expr.length;
        this.addPlan(plan, el, this.expr[es - 1]);
        for (int e = 0; e < es - 1; ++e) {
            this.expr[e].plan(el);
        }
    }

    @Override
    public String description() {
        return this.expr[this.expr.length - 1].description() + "(...)";
    }

    @Override
    public String toString() {
        int es = this.expr.length;
        TokenBuilder tb = new TokenBuilder(this.expr[es - 1].toString()).add(40);
        for (int e = 0; e < es - 1; ++e) {
            tb.add(this.expr[e].toString());
            if (e >= es - 2) continue;
            tb.add(", ");
        }
        return tb.add(41).toString();
    }

    @Override
    FItem evalFunc(QueryContext ctx) throws QueryException {
        int ar = this.expr.length - 1;
        Item it = this.checkItem(this.expr[ar], ctx);
        if (!(it instanceof FItem)) {
            throw Err.INVFUNCITEM.get(this.info, it.type);
        }
        FItem fit = (FItem)it;
        if (fit.arity() != ar) {
            throw Err.INVARITY.get(this.info, fit, ar);
        }
        if (this.updating != fit.annotations().contains(Ann.Q_UPDATING)) {
            throw (this.updating ? Err.UPFUNCNOTUP : Err.UPFUNCUP).get(this.info, new Object[0]);
        }
        return fit;
    }

    @Override
    Value[] evalArgs(QueryContext ctx) throws QueryException {
        int al = this.expr.length - 1;
        Value[] args = new Value[al];
        for (int a = 0; a < al; ++a) {
            args[a] = ctx.value(this.expr[a]);
        }
        return args;
    }

    @Override
    public boolean has(Expr.Flag flag) {
        return flag == Expr.Flag.UPD ? this.updating : super.has(flag);
    }
}

