/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.AxisMoreIter;
import org.basex.query.iter.Iter;
import org.basex.query.iter.NodeSeqBuilder;
import org.basex.query.util.Err;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FNode;
import org.basex.query.value.type.NodeType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.list.TokenList;

public final class FNId
extends StandardFunc {
    public FNId(StaticContext sctx, InputInfo ii, Function f, Expr ... e) {
        super(sctx, ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        ANode node = this.checkNode(this.expr.length == 2 ? this.expr[1] : this.checkCtx(ctx), ctx);
        switch (this.sig) {
            case ID: {
                return this.id(ctx.iter(this.expr[0]), node);
            }
            case IDREF: {
                return this.idref(ctx.iter(this.expr[0]), node);
            }
            case ELEMENT_WITH_ID: {
                return this.elid(ctx.iter(this.expr[0]), node);
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        ANode node = this.checkNode(this.expr.length == 2 ? this.expr[1] : this.checkCtx(ctx), ctx);
        switch (this.sig) {
            case LANG: {
                return FNId.lang(Token.lc(this.checkEStr(this.expr[0], ctx)), node);
            }
        }
        return super.item(ctx, ii);
    }

    private Iter elid(Iter it, ANode node) throws QueryException {
        return this.id(it, node);
    }

    private NodeSeqBuilder id(Iter it, ANode node) throws QueryException {
        NodeSeqBuilder nc = new NodeSeqBuilder().check();
        FNId.add(this.ids(it), nc, this.checkRoot(node), false);
        return nc;
    }

    private Iter idref(Iter it, ANode node) throws QueryException {
        NodeSeqBuilder nb = new NodeSeqBuilder().check();
        FNId.add(this.ids(it), nb, this.checkRoot(node), true);
        return nb;
    }

    private static Bln lang(byte[] lang, ANode node) {
        for (ANode n = node; n != null; n = n.parent()) {
            ANode at;
            AxisMoreIter atts = n.attributes();
            while ((at = atts.next()) != null) {
                if (!Token.eq(at.qname().string(), QueryText.LANG)) continue;
                byte[] ln = Token.lc(Token.norm(at.string()));
                return Bln.get(Token.startsWith(ln, lang) && (lang.length == ln.length || ln[lang.length] == 45));
            }
        }
        return Bln.FALSE;
    }

    private byte[][] ids(Iter iter) throws QueryException {
        Item id;
        TokenList tl = new TokenList();
        while ((id = iter.next()) != null) {
            for (byte[] i : Token.split(Token.norm(this.checkEStr(id)), 32)) {
                tl.add(i);
            }
        }
        return tl.toArray();
    }

    private static void add(byte[][] ids, NodeSeqBuilder nc, ANode node, boolean idref) {
        ANode att;
        ANode at;
        AxisMoreIter ai = node.attributes();
        while ((at = ai.next()) != null) {
            byte[][] val = Token.split(at.string(), 32);
            for (byte[] id : ids) {
                if (!Token.eq(id, val)) continue;
                byte[] nm = Token.lc(at.qname().string());
                boolean ii = Token.contains(nm, QueryText.ID);
                boolean ir = Token.contains(nm, QueryText.IDREF);
                if (!(idref ? ir : ii && !ir)) continue;
                nc.add(idref ? at.finish() : node);
            }
        }
        ai = node.children();
        while ((att = ai.next()) != null) {
            FNId.add(ids, nc, att.finish(), idref);
        }
    }

    private ANode checkRoot(ANode node) throws QueryException {
        if (node instanceof FNode) {
            ANode n = node;
            while (n.type != NodeType.DOC) {
                if ((n = n.parent()) != null) continue;
                throw Err.IDDOC.get(this.info, new Object[0]);
            }
        }
        return node;
    }

    @Override
    public boolean has(Expr.Flag flag) {
        return flag == Expr.Flag.CTX && this.expr.length == 1 || super.has(flag);
    }
}

