/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.util.Locale;
import org.basex.data.Data;
import org.basex.index.Index;
import org.basex.index.IndexType;
import org.basex.index.name.Names;
import org.basex.index.path.PathNode;
import org.basex.index.query.EntryIterator;
import org.basex.index.query.IndexEntries;
import org.basex.index.stats.Stats;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Err;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FDoc;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.NodeType;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class FNIndex
extends StandardFunc {
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String COUNT = "count";
    private static final String ENTRY = "entry";
    private static final String MIN = "min";
    private static final String MAX = "max";
    private static final byte[] ELM = NodeType.ELM.string();
    private static final byte[] ATT = NodeType.ATT.string();
    private static final byte[] FLAT = Token.token("flat");

    public FNIndex(StaticContext sctx, InputInfo ii, Function f, Expr ... e) {
        super(sctx, ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.sig) {
            case _INDEX_FACETS: {
                return this.facets(ctx);
            }
        }
        return super.item(ctx, ii);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case _INDEX_TEXTS: {
                return this.values(ctx, IndexType.TEXT);
            }
            case _INDEX_ATTRIBUTES: {
                return this.values(ctx, IndexType.ATTRIBUTE);
            }
            case _INDEX_ELEMENT_NAMES: {
                return this.names(ctx, IndexType.TAG);
            }
            case _INDEX_ATTRIBUTE_NAMES: {
                return this.names(ctx, IndexType.ATTNAME);
            }
        }
        return super.iter(ctx);
    }

    private Item facets(QueryContext ctx) throws QueryException {
        Data data = this.checkData(ctx);
        boolean flat = this.expr.length == 2 && Token.eq(this.checkStr(this.expr[1], ctx), FLAT);
        return new FDoc().add(flat ? FNIndex.flat(data) : FNIndex.tree(data, data.paths.root().get(0)));
    }

    private Iter values(QueryContext ctx, IndexType it) throws QueryException {
        byte[] entry;
        Data data = this.checkData(ctx);
        byte[] byArray = entry = this.expr.length < 2 ? Token.EMPTY : this.checkStr(this.expr[1], ctx);
        if (data.inMemory()) {
            throw Err.BXDB_MEM.get(this.info, data.meta.name);
        }
        IndexEntries et = this.expr.length < 3 ? new IndexEntries(entry, it) : new IndexEntries(entry, this.checkBln(this.expr[2], ctx), it);
        return FNIndex.entries(data, et, this);
    }

    static Iter entries(Data data, IndexEntries entries, StandardFunc call) throws QueryException {
        boolean avl;
        Index index;
        IndexType it = entries.type();
        if (it == IndexType.TEXT) {
            index = data.txtindex;
            avl = data.meta.textindex;
        } else if (it == IndexType.ATTRIBUTE) {
            index = data.atvindex;
            avl = data.meta.attrindex;
        } else {
            index = data.ftxindex;
            avl = data.meta.ftxtindex;
        }
        if (!avl) {
            throw Err.BXDB_INDEX.get(call.info, data.meta.name, it.toString().toLowerCase(Locale.ENGLISH));
        }
        return FNIndex.entries(index, entries);
    }

    private Iter names(QueryContext ctx, IndexType it) throws QueryException {
        Data data = this.checkData(ctx);
        return FNIndex.entries(it == IndexType.TAG ? data.tagindex : data.atnindex, new IndexEntries(Token.EMPTY, it));
    }

    private static Iter entries(final Index index, final IndexEntries entries) {
        return new Iter(){
            final EntryIterator ei;
            {
                this.ei = index.entries(entries);
            }

            @Override
            public ANode next() {
                byte[] token = this.ei.next();
                return token == null ? null : new FElem(FNIndex.ENTRY).add(FNIndex.COUNT, Token.token(this.ei.count())).add(token);
            }
        };
    }

    private static FElem flat(Data data) {
        FElem elem = new FElem(new QNm(NodeType.DOC.string()));
        FNIndex.index(data.tagindex, ELM, elem);
        FNIndex.index(data.atnindex, ATT, elem);
        return elem;
    }

    private static void index(Names names, byte[] name, FElem root) {
        int ns = names.size();
        for (int n = 1; n <= ns; ++n) {
            FElem sub = new FElem(name).add(NAME, names.key(n));
            FNIndex.stats(names.stat(n), sub);
            root.add(sub);
        }
    }

    private static FElem tree(Data data, PathNode root) {
        Names names;
        FElem elem = new FElem(new QNm(ANode.type(root.kind).string()));
        boolean elm = root.kind == 1;
        Names names2 = names = elm ? data.tagindex : data.atnindex;
        if (root.kind == 3 || elm) {
            elem.add(NAME, names.key(root.name));
        }
        FNIndex.stats(root.stats, elem);
        for (PathNode p : root.ch) {
            elem.add(FNIndex.tree(data, p));
        }
        return elem;
    }

    private static void stats(Stats stats, FElem elem) {
        String k = stats.type.toString().toLowerCase(Locale.ENGLISH);
        elem.add(TYPE, k);
        elem.add(COUNT, Token.token(stats.count));
        switch (stats.type) {
            case CATEGORY: {
                for (byte[] c : stats.cats) {
                    elem.add(new FElem(ENTRY).add(COUNT, Token.token(stats.cats.get(c))).add(c));
                }
                break;
            }
            case DOUBLE: 
            case INTEGER: {
                elem.add(MIN, Token.token(stats.min));
                elem.add(MAX, Token.token(stats.max));
                break;
            }
        }
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return this.dataLock(visitor) && super.accept(visitor);
    }
}

