/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.iter;

import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.Seq;
import org.basex.util.Array;

public abstract class Iter {
    public abstract Item next() throws QueryException;

    public Item get(long i) throws QueryException {
        return null;
    }

    public long size() {
        return -1L;
    }

    public boolean reset() {
        return false;
    }

    public Value value() throws QueryException {
        Item i = this.next();
        if (i == null) {
            return Empty.SEQ;
        }
        Item[] item = new Item[Math.max(1, (int)this.size())];
        int s = 0;
        do {
            if (s == item.length) {
                item = Iter.extend(item);
            }
            item[s++] = i;
        } while ((i = this.next()) != null);
        return Seq.get(item, s);
    }

    static Item[] extend(Item[] it) {
        return Array.copy(it, new Item[Array.newSize(it.length)]);
    }
}

