/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.iter;

import java.io.IOException;
import org.basex.data.Result;
import org.basex.io.out.ArrayOutput;
import org.basex.io.serial.Serializer;
import org.basex.query.iter.ValueIter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Seq;
import org.basex.util.Util;

public final class ValueBuilder
extends ValueIter
implements Result {
    private Item[] items;
    private int size;
    private int pos = -1;

    public ValueBuilder() {
        this(1);
    }

    public ValueBuilder(int c) {
        this.items = new Item[c];
    }

    public ValueBuilder(Item[] arr, int s) {
        this.items = arr;
        this.size = s;
    }

    public ValueBuilder add(Value val) {
        long sz = val.size();
        while ((long)(this.items.length - this.size) < sz) {
            this.items = ValueBuilder.extend(this.items);
        }
        this.size += val.writeTo(this.items, this.size);
        return this;
    }

    public ValueBuilder add(Item it) {
        if (this.size == this.items.length) {
            this.items = ValueBuilder.extend(this.items);
        }
        this.items[this.size++] = it;
        return this;
    }

    @Override
    public boolean sameAs(Result v) {
        if (!(v instanceof ValueBuilder)) {
            return false;
        }
        ValueBuilder vb = (ValueBuilder)v;
        if (this.size != vb.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.items[i].type == vb.items[i].type && this.items[i].sameAs(vb.items[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void serialize(Serializer ser) throws IOException {
        for (int c = 0; c < this.size && !ser.finished(); ++c) {
            this.serialize(ser, c);
        }
    }

    @Override
    public void serialize(Serializer ser, int n) throws IOException {
        ser.serialize(this.items[n]);
    }

    @Override
    public Item next() {
        return ++this.pos < this.size ? this.items[this.pos] : null;
    }

    public void size(int s) {
        this.size = s;
    }

    @Override
    public boolean reset() {
        this.pos = -1;
        return true;
    }

    @Override
    public long size() {
        return this.size;
    }

    public Item[] items() {
        return this.items;
    }

    @Override
    public Item get(long i) {
        return this.items[(int)i];
    }

    public void set(Item i, int p) {
        this.items[p] = i;
    }

    @Override
    public Value value() {
        return Seq.get(this.items, this.size);
    }

    @Override
    public ArrayOutput serialize() throws IOException {
        ArrayOutput ao = new ArrayOutput();
        this.serialize(Serializer.get(ao));
        return ao;
    }

    public String toString() {
        try {
            return this.serialize().toString();
        }
        catch (IOException ex) {
            throw Util.notExpected(ex);
        }
    }
}

