/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up;

import java.util.ArrayList;
import java.util.List;
import org.basex.query.QueryException;
import org.basex.query.up.primitives.DeleteNode;
import org.basex.query.up.primitives.InsertInto;
import org.basex.query.up.primitives.NodeUpdate;
import org.basex.query.up.primitives.ReplaceContent;
import org.basex.query.up.primitives.ReplaceNode;
import org.basex.query.up.primitives.ReplaceValue;
import org.basex.query.up.primitives.UpdateType;

final class NodeUpdates {
    List<NodeUpdate> updates = new ArrayList<NodeUpdate>(1);

    NodeUpdates() {
    }

    void add(NodeUpdate up) throws QueryException {
        int typeIndex = this.index(up.type);
        if (typeIndex == -1) {
            this.updates.add(up);
        } else {
            NodeUpdate nodeUp = this.updates.get(typeIndex);
            if (nodeUp instanceof InsertInto) {
                InsertInto oprim = (InsertInto)nodeUp;
                InsertInto nprim = (InsertInto)up;
                if (nprim instanceof ReplaceContent) {
                    this.updates.set(typeIndex, nprim);
                } else if (!(oprim instanceof ReplaceContent)) {
                    nodeUp.merge(up);
                }
            } else {
                nodeUp.merge(up);
            }
        }
    }

    private NodeUpdate find(UpdateType type) {
        for (NodeUpdate p : this.updates) {
            if (p.type != type) continue;
            return p;
        }
        return null;
    }

    private int index(UpdateType t) {
        int us = this.updates.size();
        for (int u = 0; u < us; ++u) {
            if (this.updates.get((int)u).type != t) continue;
            return u;
        }
        return -1;
    }

    List<NodeUpdate> finish() {
        List<NodeUpdate> primnew = new ArrayList<NodeUpdate>();
        DeleteNode del = (DeleteNode)this.find(UpdateType.DELETENODE);
        if (del != null && del.rec) {
            primnew.add(del);
            this.updates = null;
            return primnew;
        }
        ReplaceNode replace = (ReplaceNode)this.find(UpdateType.REPLACENODE);
        if (replace != null) {
            for (NodeUpdate p : this.updates) {
                if (p.type != UpdateType.REPLACENODE && p.type != UpdateType.INSERTBEFORE && p.type != UpdateType.INSERTAFTER) continue;
                primnew.add(p);
            }
            this.updates = null;
            return primnew;
        }
        ReplaceValue rec = (ReplaceValue)this.find(UpdateType.REPLACEVALUE);
        if (rec != null && rec.rec) {
            for (NodeUpdate p : this.updates) {
                if ((p.type == UpdateType.INSERTINTOFIRST || p.type == UpdateType.INSERTINTO || p.type == UpdateType.INSERTINTOLAST) && (p.type != UpdateType.INSERTINTO || !(p instanceof ReplaceContent))) continue;
                primnew.add(p);
            }
            this.updates = null;
            return primnew;
        }
        primnew = this.updates;
        this.updates = null;
        return primnew;
    }
}

