/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.primitives;

import java.util.HashMap;
import java.util.Map;
import org.basex.data.Data;
import org.basex.data.MemData;
import org.basex.io.IOFile;
import org.basex.query.QueryException;
import org.basex.query.up.primitives.DBUpdate;
import org.basex.query.up.primitives.Update;
import org.basex.query.up.primitives.UpdateType;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;

public final class DBRename
extends DBUpdate {
    private final HashMap<String, String> map = new HashMap();

    public DBRename(Data data, String src, String trg, InputInfo info) {
        super(UpdateType.DBRENAME, data, info);
        this.map.put(src, trg);
    }

    @Override
    public void merge(Update up) throws QueryException {
        for (Map.Entry<String, String> e : ((DBRename)up).map.entrySet()) {
            String src = e.getKey();
            if (this.map.containsKey(src)) {
                throw Err.UPPATHREN.get(this.info, src);
            }
            this.map.put(src, e.getValue());
        }
    }

    @Override
    public void apply() {
        for (Map.Entry<String, String> op : this.map.entrySet()) {
            IOFile src = new IOFile(op.getKey());
            IOFile trg = new IOFile(op.getValue());
            if (!src.exists()) continue;
            src.rename(trg);
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public void prepare(MemData tmp) {
    }
}

