/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.primitives;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.up.primitives.Update;
import org.basex.query.up.primitives.UpdateType;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;
import org.basex.util.list.StringList;

public abstract class NameUpdate
extends Update
implements Comparable<NameUpdate> {
    final String name;
    final QueryContext qc;

    NameUpdate(UpdateType type, String name, InputInfo info, QueryContext qc) {
        super(type, info);
        this.name = name;
        this.qc = qc;
    }

    public abstract void prepare() throws QueryException;

    public abstract void apply() throws QueryException;

    protected abstract String operation();

    @Override
    public void merge(Update up) throws QueryException {
        throw Err.BXDB_ONCE.get(this.info, this.name, this.operation());
    }

    public void databases(StringList db) {
        db.add(this.name);
    }

    public String name() {
        return this.name;
    }

    @Override
    public final int size() {
        return 1;
    }

    @Override
    public final int compareTo(NameUpdate o) {
        return this.type.ordinal() - o.type.ordinal();
    }

    final void close() throws QueryException {
        NameUpdate.close(this.name, this.qc, this.info);
    }

    static void close(String name, QueryContext qc, InputInfo info) throws QueryException {
        qc.resource.remove(name);
        if (qc.context.pinned(name)) {
            throw Err.BXDB_OPENED.get(info, name);
        }
    }
}

