/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util;

import java.util.Iterator;
import org.basex.query.value.Value;
import org.basex.query.value.node.ANode;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.type.NodeType;
import org.basex.util.ArrayIterator;
import org.basex.util.list.ElementList;

public final class ANodeList
extends ElementList
implements Iterable<ANode> {
    private ANode[] list;

    public ANodeList() {
        this(1);
    }

    public ANodeList(int c) {
        this.list = new ANode[c];
    }

    public ANodeList(ANode ... n) {
        this.list = n;
        this.size = n.length;
    }

    public void add(ANode e) {
        if (this.size == this.list.length) {
            this.copyOf(this.newSize());
        }
        this.list[this.size++] = e;
    }

    public void set(int i, ANode e) {
        if (i >= this.list.length) {
            this.copyOf(this.newSize(i + 1));
        }
        this.list[i] = e;
        this.size = Math.max(this.size, i + 1);
    }

    public ANode get(int p) {
        return this.list[p];
    }

    public Value value() {
        return Seq.get(this.list, this.size, NodeType.NOD);
    }

    private void copyOf(int s) {
        ANode[] tmp = new ANode[s];
        System.arraycopy(this.list, 0, tmp, 0, this.size);
        this.list = tmp;
    }

    @Override
    public Iterator<ANode> iterator() {
        return new ArrayIterator<ANode>(this.list, this.size);
    }
}

