/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util;

import java.util.Arrays;
import java.util.Iterator;
import org.basex.query.QueryException;
import org.basex.query.util.ItemSet;
import org.basex.query.value.item.Item;
import org.basex.util.Array;
import org.basex.util.ArrayIterator;
import org.basex.util.InputInfo;
import org.basex.util.hash.ASet;

public class HashItemSet
extends ASet
implements ItemSet {
    private int[] hash = new int[8];
    private Item[] keys = new Item[8];

    public HashItemSet() {
        super(8);
    }

    @Override
    public final boolean add(Item key, InputInfo ii) throws QueryException {
        return this.index(key, ii) > 0;
    }

    public int put(Item key, InputInfo ii) throws QueryException {
        int i = this.index(key, ii);
        return Math.abs(i);
    }

    public final int id(Item key, InputInfo ii) throws QueryException {
        int h = key.hash(ii);
        int p = h & this.bucket.length - 1;
        int id = this.bucket[p];
        while (id != 0) {
            if (this.keys[id].equiv(key, null, ii)) {
                return -id;
            }
            id = this.next[id];
        }
        return 0;
    }

    private int index(Item key, InputInfo ii) throws QueryException {
        this.checkSize();
        int h = key.hash(ii);
        int b = h & this.bucket.length - 1;
        int r = this.bucket[b];
        while (r != 0) {
            if (this.keys[r].equiv(key, null, ii)) {
                return -r;
            }
            r = this.next[r];
        }
        this.next[this.size] = this.bucket[b];
        this.keys[this.size] = key;
        this.hash[this.size] = h;
        this.bucket[b] = this.size;
        return this.size++;
    }

    @Override
    public Iterator<Item> iterator() {
        return new ArrayIterator<Item>(this.keys, 1, this.size);
    }

    @Override
    protected int hash(int id) {
        return this.hash[id];
    }

    @Override
    protected void rehash(int newSize) {
        this.keys = Array.copy(this.keys, new Item[newSize]);
        this.hash = Arrays.copyOf(this.hash, newSize);
    }
}

