/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.basex.query.QueryException;
import org.basex.query.util.Collation;
import org.basex.query.util.Err;
import org.basex.query.value.item.ADate;
import org.basex.query.value.item.ADateDur;
import org.basex.query.value.item.Dur;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class DTDur
extends Dur {
    private static final Pattern DUR = Pattern.compile("(-?)P((\\d+)D)?(T((\\d+)H)?((\\d+)M)?((\\d+(\\.\\d+)?)S)?)?");

    public DTDur(Dur d) {
        super(AtomType.DTD);
        this.sec = d.sec == null ? BigDecimal.ZERO : d.sec;
    }

    public DTDur(long h, long m) {
        super(AtomType.DTD);
        this.sec = BigDecimal.valueOf(h).multiply(BD60).add(BigDecimal.valueOf(m)).multiply(BD60);
    }

    public DTDur(long ms) {
        super(AtomType.DTD);
        this.sec = BigDecimal.valueOf(ms).divide(BD1000);
    }

    public DTDur(DTDur it, DTDur a, boolean p, InputInfo ii) throws QueryException {
        this(it);
        this.sec = p ? this.sec.add(a.sec) : this.sec.subtract(a.sec);
        double d = this.sec.doubleValue();
        if (d <= -9.223372036854776E18 || d >= 9.223372036854776E18) {
            throw Err.SECDURRANGE.get(ii, d);
        }
    }

    public DTDur(Dur it, double f, boolean m, InputInfo ii) throws QueryException {
        this(it);
        if (Double.isNaN(f)) {
            throw Err.DATECALC.get(ii, this.description(), f);
        }
        if (m ? Double.isInfinite(f) : f == 0.0) {
            throw Err.DATEZERO.get(ii, this.type);
        }
        if (m ? f == 0.0 : Double.isInfinite(f)) {
            this.sec = BigDecimal.ZERO;
        } else {
            BigDecimal d = BigDecimal.valueOf(f);
            try {
                this.sec = m ? this.sec.multiply(d) : this.sec.divide(d);
            }
            catch (ArithmeticException ex) {
                d = BigDecimal.valueOf(1.0 / f);
                BigDecimal bigDecimal = this.sec = m ? this.sec.divide(d) : this.sec.multiply(d);
            }
        }
        if (Math.abs(this.sec.doubleValue()) < 1.0E-13) {
            this.sec = BigDecimal.ZERO;
        }
    }

    public DTDur(ADate dat, ADate sub, InputInfo ii) throws QueryException {
        super(AtomType.DTD);
        this.sec = dat.days().subtract(sub.days()).multiply(DAYSECONDS).add(dat.seconds().subtract(sub.seconds()));
        double d = this.sec.doubleValue();
        if (d <= -9.223372036854776E18 || d >= 9.223372036854776E18) {
            throw Err.SECRANGE.get(ii, d);
        }
    }

    public DTDur(byte[] vl, InputInfo ii) throws QueryException {
        super(AtomType.DTD);
        String val = Token.string(vl).trim();
        Matcher mt = DUR.matcher(val);
        if (!mt.matches() || val.endsWith("P") || val.endsWith("T")) {
            throw this.dateError(vl, "P23DT12M34S", ii);
        }
        this.dayTime(vl, mt, 2, ii);
    }

    public BigDecimal dtd() {
        return this.sec;
    }

    @Override
    public byte[] string(InputInfo ii) {
        TokenBuilder tb = new TokenBuilder();
        int ss = this.sec.signum();
        if (ss < 0) {
            tb.add(45);
        }
        tb.add(80);
        if (this.day() != 0L) {
            tb.addLong(Math.abs(this.day()));
            tb.add(68);
        }
        this.time(tb);
        if (ss == 0) {
            tb.add("T0S");
        }
        return tb.finish();
    }

    @Override
    public int diff(Item it, Collation coll, InputInfo ii) throws QueryException {
        if (it.type != this.type) {
            throw Err.diffError(ii, it, this);
        }
        return this.sec.subtract(((ADateDur)it).sec).signum();
    }
}

