/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.util.Collation;
import org.basex.query.util.Err;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class Dec
extends ANum {
    public static final BigDecimal MAXULNG = new BigDecimal(Long.MAX_VALUE).multiply(BigDecimal.valueOf(2L)).add(BigDecimal.ONE);
    private static final Dec ZERO = new Dec(BigDecimal.ZERO);
    private final BigDecimal val;

    public Dec(byte[] t) {
        super(AtomType.DEC);
        this.val = new BigDecimal(Token.string(Token.trim(t)));
    }

    public Dec(BigDecimal d, Type t) {
        super(t);
        this.val = d;
    }

    private Dec(BigDecimal d) {
        super(AtomType.DEC);
        this.val = d;
    }

    public static Dec get(BigDecimal d) {
        return d.signum() == 0 ? ZERO : new Dec(d);
    }

    public static Dec get(double d) {
        return Dec.get(BigDecimal.valueOf(d));
    }

    @Override
    public byte[] string() {
        return Token.chopNumber(Token.token(this.val.toPlainString()));
    }

    @Override
    public boolean bool(InputInfo ii) {
        return this.val.signum() != 0;
    }

    @Override
    public long itr() {
        return this.val.longValue();
    }

    @Override
    public float flt() {
        return this.val.floatValue();
    }

    @Override
    public double dbl() {
        return this.val.doubleValue();
    }

    @Override
    public BigDecimal dec(InputInfo ii) {
        return this.val;
    }

    @Override
    public boolean eq(Item it, Collation coll, InputInfo ii) throws QueryException {
        return it.type == AtomType.DBL || it.type == AtomType.FLT ? it.eq(this, coll, ii) : this.val.compareTo(it.dec(ii)) == 0;
    }

    @Override
    public int diff(Item it, Collation coll, InputInfo ii) throws QueryException {
        double d = it.dbl(ii);
        return d == Double.NEGATIVE_INFINITY ? -1 : (d == Double.POSITIVE_INFINITY ? 1 : (Double.isNaN(d) ? Integer.MIN_VALUE : this.val.compareTo(it.dec(ii))));
    }

    @Override
    public Object toJava() {
        return this.type == AtomType.ULN ? new BigInteger(this.val.toString()) : this.val;
    }

    @Override
    public boolean sameAs(Expr cmp) {
        return cmp instanceof Dec && this.val.compareTo(((Dec)cmp).val) == 0;
    }

    public static BigDecimal parse(double val, InputInfo ii) throws QueryException {
        if (Double.isNaN(val) || Double.isInfinite(val)) {
            throw Err.valueError(ii, AtomType.DEC, val);
        }
        return BigDecimal.valueOf(val);
    }

    public static BigDecimal parse(byte[] val, InputInfo ii) throws QueryException {
        try {
            if (!Token.contains(val, 101) && !Token.contains(val, 69)) {
                return new BigDecimal(Token.string(val).trim());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw Err.FUNCAST.get(ii, AtomType.DEC, Err.chop(val));
    }
}

