/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.math.BigDecimal;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.util.Collation;
import org.basex.query.util.Err;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class Flt
extends ANum {
    public static final Flt NAN = new Flt(Float.NaN);
    private static final Flt ZERO = new Flt(0.0f);
    private static final Flt ONE = new Flt(1.0f);
    private final float val;

    private Flt(float v) {
        super(AtomType.FLT);
        this.val = v;
    }

    public static Flt get(float f) {
        return f == 0.0f && Float.floatToRawIntBits(f) == 0 ? ZERO : (f == 1.0f ? ONE : (Double.isNaN(f) ? NAN : new Flt(f)));
    }

    @Override
    public byte[] string() {
        return Token.token(this.val);
    }

    @Override
    public boolean bool(InputInfo ii) {
        return !Double.isNaN(this.val) && this.val != 0.0f;
    }

    @Override
    public long itr() {
        return (long)this.val;
    }

    @Override
    public float flt() {
        return this.val;
    }

    @Override
    public double dbl() {
        return this.val;
    }

    @Override
    public BigDecimal dec(InputInfo ii) throws QueryException {
        return Dec.parse(this.val, ii);
    }

    @Override
    public boolean eq(Item it, Collation coll, InputInfo ii) throws QueryException {
        return it.type == AtomType.DBL ? it.eq(this, coll, ii) : this.val == it.flt(ii);
    }

    @Override
    public int diff(Item it, Collation coll, InputInfo ii) throws QueryException {
        double n = it.flt(ii);
        if (Double.isNaN(n) || Double.isNaN(this.val)) {
            return Integer.MIN_VALUE;
        }
        return (double)this.val < n ? -1 : ((double)this.val > n ? 1 : 0);
    }

    @Override
    public Float toJava() {
        return Float.valueOf(this.val);
    }

    @Override
    public boolean sameAs(Expr cmp) {
        return cmp instanceof Flt && this.val == ((Flt)cmp).val || this == NAN && cmp == NAN;
    }

    static float parse(byte[] val, InputInfo ii) throws QueryException {
        try {
            return Float.parseFloat(Token.string(val));
        }
        catch (NumberFormatException ex) {
            if (Token.eq(Token.trim(val), Token.INF)) {
                return Float.POSITIVE_INFINITY;
            }
            if (Token.eq(Token.trim(val), Token.NINF)) {
                return Float.NEGATIVE_INFINITY;
            }
            throw Err.FUNCAST.get(ii, Flt.ZERO.type, Err.chop(val));
        }
    }
}

